/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.concurrent.statechanges;

import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.JobSteward;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolveResult;
import org.jobrunr.server.concurrent.statechanges.AbstractAllowedConcurrentStateChange;

public class DeletedWhileAnyOtherConcurrentStateChange
extends AbstractAllowedConcurrentStateChange {
    private final JobSteward jobSteward;

    public DeletedWhileAnyOtherConcurrentStateChange(JobSteward jobSteward) {
        super(null, StateName.DELETED);
        this.jobSteward = jobSteward;
    }

    @Override
    public boolean matches(StateName localState, StateName storageProviderState) {
        if (localState == StateName.DELETED && storageProviderState == StateName.DELETED) {
            return false;
        }
        return super.matches(localState, storageProviderState);
    }

    @Override
    public ConcurrentJobModificationResolveResult resolve(Job localJob, Job storageProviderJob) {
        if (localJob.getState() == StateName.DELETED && storageProviderJob.getState() == StateName.DELETED) {
            throw JobRunrException.shouldNotHappenException("Should not happen as matches filter should be filtering out this StateChangeFilter");
        }
        if (localJob.getState() == StateName.PROCESSING && storageProviderJob.getState() == StateName.DELETED) {
            localJob.delete("Job is already deleted in StorageProvider");
            Thread threadProcessingJob = this.jobSteward.getThreadProcessingJob(localJob);
            if (threadProcessingJob != null) {
                threadProcessingJob.interrupt();
            }
        }
        return ConcurrentJobModificationResolveResult.succeeded(localJob);
    }
}

