/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.concurrent.statechanges;

import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.JobSteward;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolveResult;
import org.jobrunr.server.concurrent.statechanges.AllowedConcurrentStateChange;
import org.jobrunr.utils.annotations.Because;

@Because(value={"https://github.com/jobrunr/jobrunr/issues/631"})
public class JobStateChangedWhileProcessingConcurrentStateChange
implements AllowedConcurrentStateChange {
    private final JobSteward jobSteward;

    public JobStateChangedWhileProcessingConcurrentStateChange(JobSteward jobSteward) {
        this.jobSteward = jobSteward;
    }

    @Override
    public boolean matches(Job localJob, Job storageProviderJob) {
        if (storageProviderJob.getVersion() == localJob.getVersion() + 1 && localJob.hasState(StateName.PROCESSING) && !storageProviderJob.hasState(StateName.PROCESSING)) {
            return this.jobSteward.getThreadProcessingJob(localJob) == null;
        }
        return false;
    }

    @Override
    public boolean matches(StateName localState, StateName storageProviderState) {
        throw new IllegalStateException("Should not happen as matches method is overridden");
    }

    @Override
    public ConcurrentJobModificationResolveResult resolve(Job localJob, Job storageProviderJob) {
        return ConcurrentJobModificationResolveResult.succeeded(storageProviderJob);
    }
}

