/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.concurrent.statechanges;

import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.DesktopUtils;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolveResult;
import org.jobrunr.server.concurrent.statechanges.AllowedConcurrentStateChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemSleptConcurrentStateChange
implements AllowedConcurrentStateChange {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemSleptConcurrentStateChange.class);

    @Override
    public boolean matches(StateName localState, StateName storageProviderState) {
        return DesktopUtils.systemSupportsSleepDetection() && DesktopUtils.hasSystemSleptRecently();
    }

    @Override
    public ConcurrentJobModificationResolveResult resolve(Job localJob, Job storageProviderJob) {
        if (DesktopUtils.systemSupportsSleepDetection() && DesktopUtils.hasSystemSleptRecently()) {
            LOGGER.warn("Jobs were updated concurrently but JobRunr has detected that the system has slept recently (e.g. a laptop where the lid is closed). It will disregard this ConcurrentJobModificationException and use the job from the StorageProvider.");
            return ConcurrentJobModificationResolveResult.succeeded(storageProviderJob);
        }
        throw JobRunrException.shouldNotHappenException("Should not happen as matches filter should be filtering out this StateChangeFilter");
    }
}

