/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.configuration;

import java.util.function.Function;
import org.jobrunr.server.threadpool.JobRunrExecutor;
import org.jobrunr.server.threadpool.PlatformThreadPoolJobRunrExecutor;
import org.jobrunr.server.threadpool.VirtualThreadJobRunrExecutor;
import org.jobrunr.utils.VersionNumber;

public enum BackgroundJobServerThreadType {
    PlatformThreads{

        @Override
        public Function<Integer, JobRunrExecutor> getJobRunrExecutor() {
            return PlatformThreadPoolJobRunrExecutor::new;
        }

        @Override
        public boolean isSupported(VersionNumber javaVersion) {
            return true;
        }
    }
    ,
    VirtualThreads{

        @Override
        public Function<Integer, JobRunrExecutor> getJobRunrExecutor() {
            return VirtualThreadJobRunrExecutor::new;
        }

        @Override
        public boolean isSupported(VersionNumber javaVersion) {
            return javaVersion.hasMajorVersionHigherOrEqualTo(21);
        }

        @Override
        public int getDefaultWorkerCount() {
            return super.getDefaultWorkerCount() * 2;
        }
    };


    abstract Function<Integer, JobRunrExecutor> getJobRunrExecutor();

    public abstract boolean isSupported(VersionNumber var1);

    public int getDefaultWorkerCount() {
        return Runtime.getRuntime().availableProcessors() * 8;
    }

    public static BackgroundJobServerThreadType getDefaultThreadType() {
        return VirtualThreads.isSupported(VersionNumber.JAVA_VERSION) ? VirtualThreads : PlatformThreads;
    }
}

