/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.dashboard;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jobrunr.server.dashboard.DashboardNotification;
import org.jobrunr.server.dashboard.mappers.CpuAllocationIrregularityNotificationMapper;
import org.jobrunr.server.dashboard.mappers.DashboardNotificationMapper;
import org.jobrunr.server.dashboard.mappers.PollIntervalInSecondsTimeBoxIsTooSmallNotificationMapper;
import org.jobrunr.server.dashboard.mappers.SevereJobRunrExceptionNotificationMapper;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardNotificationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardNotificationManager.class);
    private final StorageProvider storageProvider;
    private final Set<DashboardNotificationMapper<?>> notificationMappers;

    public DashboardNotificationManager(UUID backgroundJobServerId, StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
        this.notificationMappers = new HashSet<DashboardNotificationMapper>(Arrays.asList(new SevereJobRunrExceptionNotificationMapper(backgroundJobServerId, storageProvider), new CpuAllocationIrregularityNotificationMapper(backgroundJobServerId), new PollIntervalInSecondsTimeBoxIsTooSmallNotificationMapper(backgroundJobServerId)));
    }

    public void handle(Exception e) {
        if (e instanceof DashboardNotification) {
            this.notify((DashboardNotification)((Object)e));
        }
    }

    public void notify(DashboardNotification e) {
        this.notificationMappers.stream().filter(notificationMapper -> notificationMapper.supports(e)).map(notificationMapper -> notificationMapper.map(e)).forEach(this::saveDashboardNotificationAsMetadata);
    }

    public void deleteNotification(Class<? extends DashboardNotification> notificationToDelete) {
        this.storageProvider.deleteMetadata(notificationToDelete.getSimpleName());
    }

    public <T extends DashboardNotification> T getDashboardNotification(Class<T> notificationClass) {
        return (T)((DashboardNotification)this.storageProvider.getMetadata(notificationClass.getSimpleName()).stream().map(metadata -> (DashboardNotification)ReflectionUtils.newInstance(notificationClass, metadata)).findFirst().orElse(null));
    }

    private void saveDashboardNotificationAsMetadata(JobRunrMetadata metadata) {
        try {
            this.storageProvider.saveMetadata(metadata);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to save dashboard notification metadata", (Throwable)e);
        }
    }
}

