/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.metrics;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToDoubleFunction;
import org.jobrunr.server.BackgroundJobServer;

public class BackgroundJobServerMetricsBinder
implements AutoCloseable {
    private final BackgroundJobServer backgroundJobServer;
    private final MeterRegistry meterRegistry;
    private final List<Meter> meters;

    public BackgroundJobServerMetricsBinder(BackgroundJobServer backgroundJobServer, MeterRegistry meterRegistry) {
        this.backgroundJobServer = backgroundJobServer;
        this.meterRegistry = meterRegistry;
        this.meters = new ArrayList<Meter>();
        this.registerBackgroundJobServerMetrics();
    }

    public void registerBackgroundJobServerMetrics() {
        this.meters.add((Meter)this.registerFunction("poll-interval-in-seconds", bgJobServer -> bgJobServer.getServerStatus().getPollIntervalInSeconds()));
        this.meters.add((Meter)this.registerFunction("worker-pool-size", bgJobServer -> bgJobServer.getServerStatus().getWorkerPoolSize()));
        this.meters.add((Meter)this.registerGauge("process-all-located-memory", bgJobServer -> bgJobServer.getServerStatus().getProcessAllocatedMemory().longValue()));
        this.meters.add((Meter)this.registerGauge("process-free-memory", bgJobServer -> bgJobServer.getServerStatus().getProcessFreeMemory().longValue()));
        this.meters.add((Meter)this.registerGauge("system-free-memory", bgJobServer -> bgJobServer.getServerStatus().getSystemFreeMemory().longValue()));
        this.meters.add((Meter)this.registerGauge("system-total-memory", bgJobServer -> bgJobServer.getServerStatus().getSystemTotalMemory().longValue()));
        this.meters.add((Meter)this.registerGauge("first-heartbeat", bgJobServer -> bgJobServer.getServerStatus().getFirstHeartbeat().getEpochSecond()));
        this.meters.add((Meter)this.registerGauge("last-heartbeat", bgJobServer -> bgJobServer.getServerStatus().getLastHeartbeat().getEpochSecond()));
        this.meters.add((Meter)this.registerGauge("system-cpu-load", bgJobServer -> bgJobServer.getServerStatus().getSystemCpuLoad()));
        this.meters.add((Meter)this.registerGauge("process-cpu-load", bgJobServer -> bgJobServer.getServerStatus().getProcessCpuLoad()));
    }

    private FunctionCounter registerFunction(String name, ToDoubleFunction<BackgroundJobServer> func) {
        return FunctionCounter.builder((String)this.toMicroMeterName(name), (Object)this.backgroundJobServer, func).tag("id", this.backgroundJobServer.getId().toString()).register(this.meterRegistry);
    }

    private Gauge registerGauge(String name, ToDoubleFunction<BackgroundJobServer> func) {
        return Gauge.builder((String)this.toMicroMeterName(name), (Object)this.backgroundJobServer, func).tag("id", this.backgroundJobServer.getId().toString()).register(this.meterRegistry);
    }

    private String toMicroMeterName(String name) {
        return "jobrunr.background-job-server." + name;
    }

    @Override
    public void close() {
        this.meters.forEach(meter -> {
            try {
                meter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

