/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks;

import java.time.Duration;
import java.time.Instant;
import org.jobrunr.server.BackgroundJobServerConfigurationReader;
import org.jobrunr.server.tasks.TaskRunInfo;
import org.jobrunr.server.tasks.TaskStatistics;
import org.slf4j.MDC;

public class PeriodicTaskRunInfo
extends TaskRunInfo
implements AutoCloseable {
    private static final String RUN_COUNTER_MDC_KEY = "jobrunr.zooKeeper.runCounter";
    private final TaskStatistics taskStatistics;
    private final Duration pollIntervalTimeBoxDuration;
    private final long runIndex;
    private boolean runSucceeded;

    public PeriodicTaskRunInfo(TaskStatistics taskStatistics, BackgroundJobServerConfigurationReader backgroundJobServerConfiguration, long runIndex) {
        super(backgroundJobServerConfiguration);
        this.taskStatistics = taskStatistics;
        this.pollIntervalTimeBoxDuration = this.getBackgroundJobServerConfiguration().getPollInterval().multipliedBy(95L).dividedBy(100L);
        this.runIndex = runIndex;
        this.runSucceeded = false;
        MDC.put((String)RUN_COUNTER_MDC_KEY, (String)String.valueOf(runIndex));
    }

    @Override
    public boolean pollIntervalInSecondsTimeBoxIsAboutToPass() {
        Duration runTimeDuration = Duration.between(this.getRunStartTime(), Instant.now());
        return runTimeDuration.compareTo(this.pollIntervalTimeBoxDuration) >= 0;
    }

    public void markRunAsSucceeded() {
        this.runSucceeded = true;
    }

    @Override
    public void close() {
        MDC.remove((String)RUN_COUNTER_MDC_KEY);
        this.taskStatistics.logRun(this.runIndex, this.runSucceeded, this.getBackgroundJobServerConfiguration().getPollInterval(), this.getRunStartTime(), Instant.now());
    }
}

