/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jobrunr.SevereJobRunrException;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.filters.JobFilterUtils;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfigurationReader;
import org.jobrunr.server.concurrent.UnresolvableConcurrentJobModificationException;
import org.jobrunr.server.tasks.TaskRunInfo;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final BackgroundJobServer backgroundJobServer;
    protected final StorageProvider storageProvider;
    protected final JobFilterUtils jobFilterUtils;
    protected TaskRunInfo runInfo;

    protected Task(BackgroundJobServer backgroundJobServer) {
        this.backgroundJobServer = backgroundJobServer;
        this.storageProvider = backgroundJobServer.getStorageProvider();
        this.jobFilterUtils = new JobFilterUtils(backgroundJobServer.getJobFilters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskRunInfo runInfo) {
        try {
            this.runInfo = runInfo;
            if (this.pollIntervalInSecondsTimeBoxIsAboutToPass()) {
                return;
            }
            long startTime = System.nanoTime();
            this.runTask();
            long endTime = System.nanoTime();
            this.LOGGER.trace("task took {}.", (Object)Duration.ofNanos(endTime - startTime));
        }
        finally {
            this.runInfo = null;
        }
    }

    protected abstract void runTask();

    protected final <T> void convertAndProcessJobs(List<T> items, Function<T, Job> toJobFunction) {
        List<Job> jobs = items.stream().map(toJobFunction).filter(Objects::nonNull).collect(Collectors.toList());
        this.saveAndRunJobFilters(jobs);
    }

    protected void saveAndRunJobFilters(List<Job> jobs) {
        if (jobs.isEmpty()) {
            return;
        }
        try {
            this.jobFilterUtils.runOnStateElectionFilter(jobs);
            this.storageProvider.save(jobs);
            this.jobFilterUtils.runOnStateAppliedFilters(jobs);
        }
        catch (ConcurrentJobModificationException concurrentJobModificationException) {
            try {
                this.backgroundJobServer.getConcurrentJobModificationResolver().resolve(concurrentJobModificationException);
            }
            catch (UnresolvableConcurrentJobModificationException unresolvableConcurrentJobModificationException) {
                throw new SevereJobRunrException("Could not resolve ConcurrentJobModificationException", unresolvableConcurrentJobModificationException);
            }
        }
    }

    protected BackgroundJobServerConfigurationReader backgroundJobServerConfiguration() {
        return this.runInfo.getBackgroundJobServerConfiguration();
    }

    protected Instant runStartTime() {
        return this.runInfo.getRunStartTime();
    }

    protected boolean pollIntervalInSecondsTimeBoxIsAboutToPass() {
        return this.runInfo.pollIntervalInSecondsTimeBoxIsAboutToPass();
    }
}

