/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks;

import java.time.Duration;
import java.time.Instant;
import org.jobrunr.server.BackgroundJobServerConfigurationReader;
import org.jobrunr.server.dashboard.DashboardNotificationManager;
import org.jobrunr.server.dashboard.PollIntervalInSecondsTimeBoxIsTooSmallNotification;
import org.jobrunr.server.tasks.PeriodicTaskRunInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatistics {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStatistics.class);
    private final DashboardNotificationManager dashboardNotificationManager;
    private long runCounter;
    private int exceptionCounter;
    private int runTookToLongCounter;

    public TaskStatistics(DashboardNotificationManager dashboardNotificationManager) {
        this.dashboardNotificationManager = dashboardNotificationManager;
        this.runCounter = 0L;
        this.exceptionCounter = 0;
        this.runTookToLongCounter = 0;
    }

    public PeriodicTaskRunInfo startRun(BackgroundJobServerConfigurationReader backgroundJobServerConfiguration) {
        return new PeriodicTaskRunInfo(this, backgroundJobServerConfiguration, ++this.runCounter);
    }

    public void handleException(Exception e) {
        ++this.exceptionCounter;
        this.dashboardNotificationManager.handle(e);
    }

    public boolean hasTooManyExceptions() {
        return this.exceptionCounter > 5;
    }

    void logRun(long runIndex, boolean runSucceeded, Duration pollInterval, Instant runStartTime, Instant runEndTime) {
        Duration actualRunDuration;
        if (runSucceeded && this.exceptionCounter > 0) {
            --this.exceptionCounter;
        }
        if ((actualRunDuration = Duration.between(runStartTime, runEndTime)).compareTo(pollInterval) < 0) {
            LOGGER.debug("JobZooKeeper run took {}", (Object)actualRunDuration);
            this.runTookToLongCounter = 0;
        } else {
            LOGGER.debug("JobZooKeeper run took {} (while pollIntervalInSeconds is {})", (Object)actualRunDuration, (Object)pollInterval);
            if (this.runTookToLongCounter < 2) {
                ++this.runTookToLongCounter;
            } else {
                this.dashboardNotificationManager.notify(new PollIntervalInSecondsTimeBoxIsTooSmallNotification(runIndex, (int)pollInterval.getSeconds(), runStartTime, (int)actualRunDuration.getSeconds()));
                this.runTookToLongCounter = 0;
            }
        }
    }
}

