/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks.startup;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.AbstractJob;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.CollectionUtils;
import org.jobrunr.utils.JobUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckIfAllJobsExistTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundJobServer.class);
    private final StorageProvider storageProvider;

    public CheckIfAllJobsExistTask(BackgroundJobServer backgroundJobServer) {
        this.storageProvider = backgroundJobServer.getStorageProvider();
    }

    @Override
    public void run() {
        try {
            Set<String> distinctRecurringJobSignatures = this.getDistinctRecurringJobSignaturesThatDoNotExistAnymore();
            Set<String> distinctScheduledJobSignatures = this.getDistinctScheduledJobSignaturesThatDoNotExistAnymore();
            Set jobsThatCannotBeFound = CollectionUtils.asSet(new Collection[]{distinctRecurringJobSignatures, distinctScheduledJobSignatures});
            if (!distinctRecurringJobSignatures.isEmpty() || !distinctScheduledJobSignatures.isEmpty()) {
                String jobStateThatIsNotFound = this.jobTypeNotFoundLabel(distinctRecurringJobSignatures, distinctScheduledJobSignatures);
                LOGGER.warn("JobRunr found {} jobs that do not exist anymore in your code. These jobs will fail with a JobNotFoundException (due to a ClassNotFoundException or a MethodNotFoundException).\n\tBelow you can find the method signatures of the jobs that cannot be found anymore: {}", (Object)jobStateThatIsNotFound, (Object)jobsThatCannotBeFound.stream().map(sign -> "\n\t" + sign + ",").collect(Collectors.joining()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception running `CheckIfAllJobsExistTask`", (Throwable)JobRunrException.shouldNotHappenException(e));
        }
    }

    private Set<String> getDistinctRecurringJobSignaturesThatDoNotExistAnymore() {
        return this.storageProvider.getRecurringJobs().stream().map(AbstractJob::getJobSignature).filter(jobSignature -> !JobUtils.jobExists(jobSignature)).collect(Collectors.toSet());
    }

    private Set<String> getDistinctScheduledJobSignaturesThatDoNotExistAnymore() {
        return this.storageProvider.getDistinctJobSignatures(StateName.SCHEDULED).stream().filter(jobSignature -> !JobUtils.jobExists(jobSignature)).collect(Collectors.toSet());
    }

    private String jobTypeNotFoundLabel(Set<String> distinctRecurringJobSignaturesThatDoNotExistAnymoreAfterCleanup, Set<String> distinctScheduledJobSignaturesThatDoNotExistAnymoreAfterCleanup) {
        String jobStateThatIsNotFound = "";
        if (!distinctRecurringJobSignaturesThatDoNotExistAnymoreAfterCleanup.isEmpty()) {
            jobStateThatIsNotFound = jobStateThatIsNotFound + "RECURRING";
        }
        if (!distinctRecurringJobSignaturesThatDoNotExistAnymoreAfterCleanup.isEmpty() && !distinctScheduledJobSignaturesThatDoNotExistAnymoreAfterCleanup.isEmpty()) {
            jobStateThatIsNotFound = jobStateThatIsNotFound + " AND ";
        }
        if (!distinctScheduledJobSignaturesThatDoNotExistAnymoreAfterCleanup.isEmpty()) {
            jobStateThatIsNotFound = jobStateThatIsNotFound + "SCHEDULED";
        }
        return jobStateThatIsNotFound;
    }
}

