/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks.steward;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.jobrunr.jobs.Job;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.strategy.WorkDistributionStrategy;
import org.jobrunr.server.tasks.steward.AbstractJobStewardTask;
import org.jobrunr.storage.navigation.AmountRequest;

public class OnboardNewWorkTask
extends AbstractJobStewardTask {
    private final ReentrantLock reentrantLock = new ReentrantLock();
    private final WorkDistributionStrategy workDistributionStrategy;

    public OnboardNewWorkTask(BackgroundJobServer backgroundJobServer) {
        super(backgroundJobServer);
        this.workDistributionStrategy = backgroundJobServer.getWorkDistributionStrategy();
    }

    public void runTaskThreadSafe() {
        this.runTask();
    }

    @Override
    protected void runTask() {
        if (this.backgroundJobServer.isRunning() && this.reentrantLock.tryLock()) {
            try {
                this.LOGGER.trace("Looking for enqueued jobs... ");
                AmountRequest workPageRequest = this.workDistributionStrategy.getWorkPageRequest();
                if (workPageRequest.getLimit() > 0) {
                    List<Job> enqueuedJobs = this.storageProvider.getJobsToProcess(this.backgroundJobServer, workPageRequest);
                    enqueuedJobs.forEach(this.backgroundJobServer::processJob);
                    this.LOGGER.debug("Found {} enqueued jobs to process.", (Object)enqueuedJobs.size());
                }
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
    }
}

