/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks.zookeeper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.tasks.Task;
import org.jobrunr.utils.streams.StreamUtils;

public abstract class AbstractJobZooKeeperTask
extends Task {
    protected AbstractJobZooKeeperTask(BackgroundJobServer backgroundJobServer) {
        super(backgroundJobServer);
    }

    protected final void processManyJobs(Function<List<Job>, List<Job>> jobListSupplier, Consumer<Job> jobConsumer, Consumer<Integer> amountOfProcessedJobsConsumer) {
        this.convertAndProcessManyJobs(jobListSupplier, StreamUtils.consumerToFunction(jobConsumer), amountOfProcessedJobsConsumer);
    }

    protected final <T> void convertAndProcessManyJobs(Function<List<T>, List<T>> itemSupplier, Function<T, Job> toJobFunction, Consumer<Integer> amountOfProcessedJobsConsumer) {
        int amountOfProcessedJobs = 0;
        List<T> items = this.getItemsToProcess(itemSupplier, null);
        while (!items.isEmpty()) {
            this.convertAndProcessJobs(items, toJobFunction);
            amountOfProcessedJobs += items.size();
            items = this.getItemsToProcess(itemSupplier, items);
        }
        amountOfProcessedJobsConsumer.accept(amountOfProcessedJobs);
    }

    protected final <T> void convertAndProcessManyJobs(List<T> items, Function<T, List<Job>> toJobsFunction, Consumer<Integer> amountOfProcessedJobsConsumer) {
        List<Job> jobs = items.stream().map(toJobsFunction).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        this.saveAndRunJobFilters(jobs);
        amountOfProcessedJobsConsumer.accept(jobs.size());
    }

    protected <T> List<T> getItemsToProcess(Function<List<T>, List<T>> jobListSupplier, List<T> previousItemsToProcess) {
        if (this.pollIntervalInSecondsTimeBoxIsAboutToPass()) {
            return Collections.emptyList();
        }
        return jobListSupplier.apply(previousItemsToProcess);
    }
}

