/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks.zookeeper;

import java.time.Instant;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.tasks.zookeeper.AbstractJobZooKeeperTask;

public class DeleteDeletedJobsPermanentlyTask
extends AbstractJobZooKeeperTask {
    public DeleteDeletedJobsPermanentlyTask(BackgroundJobServer backgroundJobServer) {
        super(backgroundJobServer);
    }

    @Override
    protected void runTask() {
        this.LOGGER.trace("Looking for deleted jobs that can be deleted permanently...");
        int totalAmountOfPermanentlyDeletedJobs = this.storageProvider.deleteJobsPermanently(StateName.DELETED, Instant.now().minus(this.backgroundJobServerConfiguration().getPermanentlyDeleteDeletedJobsAfter()));
        this.LOGGER.debug("Found {} deleted jobs that were permanently deleted as part of JobRunr maintenance", (Object)totalAmountOfPermanentlyDeletedJobs);
    }
}

