/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks.zookeeper;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.tasks.zookeeper.AbstractJobZooKeeperTask;
import org.jobrunr.storage.Paging;

public class DeleteSucceededJobsTask
extends AbstractJobZooKeeperTask {
    private final int pageRequestSize;

    public DeleteSucceededJobsTask(BackgroundJobServer backgroundJobServer) {
        super(backgroundJobServer);
        this.pageRequestSize = backgroundJobServer.getConfiguration().getSucceededJobsRequestSize();
    }

    @Override
    protected void runTask() {
        this.LOGGER.trace("Looking for succeeded jobs that can go to the deleted state... ");
        Instant updatedBefore = Instant.now().minus(this.backgroundJobServerConfiguration().getDeleteSucceededJobsAfter());
        this.processManyJobs(previousResults -> this.getSucceededJobs(updatedBefore, (List<Job>)previousResults), job -> job.delete("JobRunr maintenance - deleting succeeded job"), this::handleTotalAmountOfSucceededJobs);
    }

    private List<Job> getSucceededJobs(Instant updatedBefore, List<Job> previousResults) {
        if (previousResults != null && previousResults.size() < this.pageRequestSize) {
            return Collections.emptyList();
        }
        return this.storageProvider.getJobList(StateName.SUCCEEDED, updatedBefore, Paging.AmountBasedList.ascOnUpdatedAt(this.pageRequestSize));
    }

    private void handleTotalAmountOfSucceededJobs(int totalAmountOfSucceededJobs) {
        if (totalAmountOfSucceededJobs > 0) {
            this.storageProvider.publishTotalAmountOfSucceededJobs(totalAmountOfSucceededJobs);
        }
        this.LOGGER.debug("Found {} succeeded jobs that moved to DELETED state as part of JobRunr maintenance", (Object)totalAmountOfSucceededJobs);
    }
}

