/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks.zookeeper;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.tasks.zookeeper.AbstractJobZooKeeperTask;
import org.jobrunr.storage.Paging;

public class ProcessOrphanedJobsTask
extends AbstractJobZooKeeperTask {
    private final int pageRequestSize;
    private final Duration serverTimeoutDuration;

    public ProcessOrphanedJobsTask(BackgroundJobServer backgroundJobServer) {
        super(backgroundJobServer);
        this.pageRequestSize = backgroundJobServer.getConfiguration().getOrphanedJobsRequestSize();
        this.serverTimeoutDuration = backgroundJobServer.getConfiguration().getPollInterval().multipliedBy(backgroundJobServer.getConfiguration().getServerTimeoutPollIntervalMultiplicand().intValue());
    }

    @Override
    protected void runTask() {
        this.LOGGER.trace("Looking for orphan jobs... ");
        Instant updatedBefore = this.runStartTime().minus(this.serverTimeoutDuration);
        this.processManyJobs(previousResults -> this.getOrphanedJobs(updatedBefore, (List<Job>)previousResults), this::changeJobStateToFailedAndRunJobFilter, totalAmountOfOrphanedJobs -> this.LOGGER.debug("Found {} orphan jobs.", totalAmountOfOrphanedJobs));
    }

    private List<Job> getOrphanedJobs(Instant updatedBefore, List<Job> previousResults) {
        if (previousResults != null && previousResults.size() < this.pageRequestSize) {
            return Collections.emptyList();
        }
        return this.storageProvider.getJobList(StateName.PROCESSING, updatedBefore, Paging.AmountBasedList.ascOnUpdatedAt(this.pageRequestSize));
    }

    private void changeJobStateToFailedAndRunJobFilter(Job job) {
        IllegalThreadStateException e = new IllegalThreadStateException("Job was too long in PROCESSING state without being updated.");
        this.jobFilterUtils.runOnJobProcessingFailedFilters(job, e);
        job.failed("Orphaned job", e);
    }
}

