/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks.zookeeper;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.tasks.zookeeper.AbstractJobZooKeeperTask;
import org.jobrunr.storage.RecurringJobsResult;

public class ProcessRecurringJobsTask
extends AbstractJobZooKeeperTask {
    private final Map<String, Instant> recurringJobRuns = new HashMap<String, Instant>();
    private RecurringJobsResult recurringJobs = new RecurringJobsResult();

    public ProcessRecurringJobsTask(BackgroundJobServer backgroundJobServer) {
        super(backgroundJobServer);
    }

    @Override
    protected void runTask() {
        this.LOGGER.trace("Looking for recurring jobs... ");
        Instant from = this.runStartTime();
        Instant upUntil = this.runStartTime().plus(this.backgroundJobServerConfiguration().getPollInterval());
        List<RecurringJob> recurringJobs = this.getRecurringJobs();
        this.convertAndProcessManyJobs(recurringJobs, (T recurringJob) -> this.toScheduledJobs((RecurringJob)recurringJob, from, upUntil), (Integer totalAmountOfJobs) -> this.LOGGER.debug("Found {} jobs to schedule from {} recurring jobs", totalAmountOfJobs, (Object)recurringJobs.size()));
    }

    private List<RecurringJob> getRecurringJobs() {
        if (this.storageProvider.recurringJobsUpdated(this.recurringJobs.getLastModifiedHash())) {
            this.recurringJobs = this.storageProvider.getRecurringJobs();
        }
        return this.recurringJobs;
    }

    List<Job> toScheduledJobs(RecurringJob recurringJob, Instant from, Instant upUntil) {
        List<Job> jobsToSchedule = this.getJobsToSchedule(recurringJob, from, upUntil);
        if (jobsToSchedule.isEmpty()) {
            this.LOGGER.trace("Recurring job '{}' resulted in 0 scheduled job.", (Object)recurringJob.getJobName());
        } else if (jobsToSchedule.size() > 1) {
            this.LOGGER.info("Recurring job '{}' resulted in {} scheduled jobs. This means a long GC happened and JobRunr is catching up.", (Object)recurringJob.getJobName(), (Object)jobsToSchedule.size());
        } else if (this.isAlreadyScheduledEnqueuedOrProcessing(recurringJob)) {
            this.LOGGER.info("Recurring job '{}' is already scheduled, enqueued or processing. Run will be skipped as job is taking longer than given CronExpression or Interval.", (Object)recurringJob.getJobName());
            jobsToSchedule.clear();
        } else if (jobsToSchedule.size() == 1) {
            this.LOGGER.debug("Recurring job '{}' resulted in 1 scheduled job.", (Object)recurringJob.getJobName());
        }
        this.registerRecurringJobRun(recurringJob, upUntil);
        return jobsToSchedule;
    }

    private List<Job> getJobsToSchedule(RecurringJob recurringJob, Instant runStartTime, Instant upUntil) {
        Instant lastRun = this.recurringJobRuns.getOrDefault(recurringJob.getId(), runStartTime);
        return recurringJob.toScheduledJobs(lastRun, upUntil);
    }

    private boolean isAlreadyScheduledEnqueuedOrProcessing(RecurringJob recurringJob) {
        return this.storageProvider.recurringJobExists(recurringJob.getId(), StateName.SCHEDULED, StateName.ENQUEUED, StateName.PROCESSING);
    }

    private void registerRecurringJobRun(RecurringJob recurringJob, Instant upUntil) {
        this.recurringJobRuns.put(recurringJob.getId(), upUntil);
    }
}

