/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks.zookeeper;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.jobrunr.jobs.Job;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.tasks.zookeeper.AbstractJobZooKeeperTask;
import org.jobrunr.storage.Paging;

public class ProcessScheduledJobsTask
extends AbstractJobZooKeeperTask {
    private final int pageRequestSize;

    public ProcessScheduledJobsTask(BackgroundJobServer backgroundJobServer) {
        super(backgroundJobServer);
        this.pageRequestSize = backgroundJobServer.getConfiguration().getScheduledJobsRequestSize();
    }

    @Override
    protected void runTask() {
        this.LOGGER.trace("Looking for scheduled jobs... ");
        Instant scheduledBefore = Instant.now().plus(this.backgroundJobServerConfiguration().getPollInterval());
        this.processManyJobs(previousResults -> this.getJobsToSchedule(scheduledBefore, (List<Job>)previousResults), Job::enqueue, totalAmountOfEnqueuedJobs -> this.LOGGER.debug("Found {} scheduled jobs to enqueue.", totalAmountOfEnqueuedJobs));
    }

    private List<Job> getJobsToSchedule(Instant scheduledBefore, List<Job> previousResults) {
        if (previousResults != null && previousResults.size() < this.pageRequestSize) {
            return Collections.emptyList();
        }
        return this.storageProvider.getScheduledJobs(scheduledBefore, Paging.AmountBasedList.ascOnUpdatedAt(this.pageRequestSize));
    }
}

