/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.threadpool;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jobrunr.server.threadpool.JobRunrExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformThreadPoolJobRunrExecutor
extends ScheduledThreadPoolExecutor
implements JobRunrExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformThreadPoolJobRunrExecutor.class);
    private final int workerCount;

    public PlatformThreadPoolJobRunrExecutor(int corePoolSize) {
        this(corePoolSize, "backgroundjob-worker-pool");
    }

    public PlatformThreadPoolJobRunrExecutor(int corePoolSize, String threadNamePrefix) {
        this(corePoolSize, corePoolSize * 2, threadNamePrefix);
    }

    public PlatformThreadPoolJobRunrExecutor(int corePoolSize, int maxPoolSize, String threadNamePrefix) {
        super(corePoolSize, new NamedThreadFactory(threadNamePrefix));
        this.workerCount = corePoolSize;
        this.setMaximumPoolSize(maxPoolSize);
        this.setKeepAliveTime(1L, TimeUnit.MINUTES);
    }

    @Override
    public int getWorkerCount() {
        return this.workerCount;
    }

    @Override
    public void start() {
        this.prestartAllCoreThreads();
        LOGGER.info("ThreadManager of type 'ScheduledThreadPool' started");
    }

    @Override
    public void stop(Duration awaitTimeout) {
        this.shutdown();
        try {
            if (!this.awaitTermination(awaitTimeout.getSeconds(), TimeUnit.SECONDS)) {
                this.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isStopping() {
        return this.isTerminating() || this.isTerminated();
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final String poolName;
        private final ThreadFactory threadFactory;

        public NamedThreadFactory(String poolName) {
            this.poolName = poolName;
            this.threadFactory = Executors.defaultThreadFactory();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.threadFactory.newThread(runnable);
            thread.setName(thread.getName().replace("pool", this.poolName));
            return thread;
        }
    }
}

