/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.threadpool;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jobrunr.server.threadpool.JobRunrExecutor;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualThreadJobRunrExecutor
implements JobRunrExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualThreadJobRunrExecutor.class);
    private final ExecutorService executorService;
    private final int workerCount;
    private boolean started;
    private boolean isStopping;

    public VirtualThreadJobRunrExecutor(int workerCount) {
        this(workerCount, "backgroundjob-worker");
    }

    public VirtualThreadJobRunrExecutor(int workerCount, String name) {
        this(workerCount, VirtualThreadJobRunrExecutor.createVirtualThreadExecutorService(name));
    }

    public VirtualThreadJobRunrExecutor(int workerCount, ExecutorService executorService) {
        this.workerCount = workerCount;
        this.executorService = executorService;
    }

    @Override
    public int getWorkerCount() {
        return this.workerCount;
    }

    @Override
    public void start() {
        this.started = true;
        LOGGER.info("ThreadManager of type 'VirtualThreadPerTask' started");
    }

    @Override
    public void stop(Duration awaitTimeout) {
        this.isStopping = true;
        this.started = false;
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(awaitTimeout.getSeconds(), TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isStopping() {
        return this.isStopping;
    }

    @Override
    public void execute(Runnable command) {
        if (this.started) {
            this.executorService.submit(command);
        }
    }

    static ExecutorService createVirtualThreadExecutorService(String name) {
        try {
            Method virtualThreadBuilderMethod = ReflectionUtils.findMethod(Thread.class, "ofVirtual", new Class[0]).orElseThrow(() -> new NoSuchMethodException("java.lang.Thread.ofVirtual()"));
            Object virtualThreadBuilder = virtualThreadBuilderMethod.invoke(null, new Object[0]);
            Method nameVirtualThreadBuilderMethod = ReflectionUtils.findMethod(virtualThreadBuilderMethod.getReturnType(), "name", String.class).orElseThrow(() -> new NoSuchMethodException("java.lang.Thread.Builder.OfVirtual.name(java.lang.String)"));
            virtualThreadBuilder = nameVirtualThreadBuilderMethod.invoke(virtualThreadBuilder, name);
            Method factoryVirtualThreadBuilderMethod = ReflectionUtils.findMethod(Class.forName("java.lang.Thread$Builder"), "factory", new Class[0]).orElseThrow(() -> new NoSuchMethodException("java.lang.Thread.Builder.OfVirtual.factory()"));
            ThreadFactory factory = (ThreadFactory)factoryVirtualThreadBuilderMethod.invoke(virtualThreadBuilder, new Object[0]);
            Method newThreadPerTaskExecutorMethod = ReflectionUtils.findMethod(Executors.class, "newThreadPerTaskExecutor", ThreadFactory.class).orElseThrow(() -> new NoSuchMethodException("java.util.concurrent.Executors.newThreadPerTaskExecutor(java.util.concurrent.ThreadFactory)"));
            return (ExecutorService)newThreadPerTaskExecutorMethod.invoke(null, factory);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Could not create VirtualThreadJobRunrExecutor on Java " + System.getProperty("java.version"), e);
        }
    }
}

