/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobId;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.InMemoryStorageProvider;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStatsEnricher;
import org.jobrunr.storage.JobStatsExtended;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.listeners.BackgroundJobServerStatusChangeListener;
import org.jobrunr.storage.listeners.JobChangeListener;
import org.jobrunr.storage.listeners.JobStatsChangeListener;
import org.jobrunr.storage.listeners.MetadataChangeListener;
import org.jobrunr.storage.listeners.StorageProviderChangeListener;
import org.jobrunr.utils.resilience.RateLimiter;
import org.jobrunr.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageProvider
implements StorageProvider,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStorageProvider.class);
    private final Set<StorageProviderChangeListener> onChangeListeners = ConcurrentHashMap.newKeySet();
    private final JobStatsEnricher jobStatsEnricher = new JobStatsEnricher();
    private final RateLimiter changeListenerNotificationRateLimit;
    private final ReentrantLock timerReentrantLock;
    private final ReentrantLock notifyJobStatsChangeListenersReentrantLock;
    private volatile Timer timer;

    protected AbstractStorageProvider(RateLimiter changeListenerNotificationRateLimit) {
        this.changeListenerNotificationRateLimit = changeListenerNotificationRateLimit;
        this.timerReentrantLock = new ReentrantLock();
        this.notifyJobStatsChangeListenersReentrantLock = new ReentrantLock();
    }

    @Override
    public StorageProvider.StorageProviderInfo getStorageProviderInfo() {
        return new StorageProvider.StorageProviderInfo(this);
    }

    @Override
    public void addJobStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.onChangeListeners.add(listener);
        this.startTimerToSendUpdates();
    }

    @Override
    public void removeJobStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.onChangeListeners.remove(listener);
        if (this.onChangeListeners.isEmpty()) {
            this.stopTimerToSendUpdates();
        }
    }

    @Override
    public void close() {
        this.stopTimerToSendUpdates();
    }

    @Override
    public final void validatePollInterval(Duration pollInterval) {
        if (this instanceof InMemoryStorageProvider) {
            if (pollInterval.compareTo(Duration.ofMillis(200L)) < 0) {
                throw new IllegalArgumentException("The smallest supported pollInterval for the InMemoryStorageProvider is 200ms.");
            }
        } else if (pollInterval.compareTo(Duration.ofSeconds(5L)) < 0) {
            throw new IllegalArgumentException("The smallest supported pollInterval is 5 seconds - otherwise it will cause to much load on your SQL/noSQL datastore.");
        }
    }

    @Override
    public final void validateRecurringJobInterval(Duration durationBetweenRecurringJobInstances) {
        if (this instanceof InMemoryStorageProvider) {
            if (durationBetweenRecurringJobInstances.compareTo(Duration.ofSeconds(1L)) < 0) {
                throw new IllegalArgumentException("The smallest supported duration between recurring job instances for the InMemoryStorageProvider is 1s.");
            }
        } else if (durationBetweenRecurringJobInstances.compareTo(Duration.ofSeconds(5L)) < 0) {
            throw new IllegalArgumentException("The smallest supported duration between recurring job instances is 5 seconds (because of the smallest supported pollInterval).");
        }
    }

    protected void notifyJobStatsOnChangeListenersIf(boolean mustNotify) {
        if (mustNotify) {
            this.notifyJobStatsOnChangeListeners();
        }
    }

    protected void notifyJobStatsOnChangeListeners() {
        List jobStatsChangeListeners = StreamUtils.ofType(this.onChangeListeners, JobStatsChangeListener.class).collect(Collectors.toList());
        if (!jobStatsChangeListeners.isEmpty()) {
            CompletableFuture.runAsync(() -> {
                try {
                    if (!this.notifyJobStatsChangeListenersReentrantLock.tryLock()) {
                        return;
                    }
                    if (this.changeListenerNotificationRateLimit.isRateLimited()) {
                        return;
                    }
                    JobStatsExtended extendedJobStats = this.jobStatsEnricher.enrich(this.getJobStats());
                    jobStatsChangeListeners.forEach(listener -> listener.onChange(extendedJobStats));
                }
                catch (Exception e) {
                    this.logError(e);
                }
                finally {
                    if (this.notifyJobStatsChangeListenersReentrantLock.isHeldByCurrentThread()) {
                        this.notifyJobStatsChangeListenersReentrantLock.unlock();
                    }
                }
            });
        }
    }

    protected void notifyMetadataChangeListeners(boolean mustNotify) {
        if (mustNotify) {
            this.notifyMetadataChangeListeners();
        }
    }

    protected void notifyMetadataChangeListeners() {
        try {
            Map<String, List<MetadataChangeListener>> metadataChangeListenersByName = StreamUtils.ofType(this.onChangeListeners, MetadataChangeListener.class).collect(Collectors.groupingBy(MetadataChangeListener::listenForChangesOfMetadataName));
            if (!metadataChangeListenersByName.isEmpty()) {
                metadataChangeListenersByName.forEach((metadataName, listeners) -> {
                    List<JobRunrMetadata> jobRunrMetadata = this.getMetadata((String)metadataName);
                    listeners.forEach(listener -> listener.onChange(jobRunrMetadata));
                });
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void notifyJobChangeListeners() {
        try {
            Map<JobId, List<JobChangeListener>> listenerByJob = StreamUtils.ofType(this.onChangeListeners, JobChangeListener.class).collect(Collectors.groupingBy(JobChangeListener::getJobId));
            if (!listenerByJob.isEmpty()) {
                listenerByJob.forEach((jobId, listeners) -> {
                    try {
                        Job job = this.getJobById((JobId)jobId);
                        listeners.forEach(listener -> listener.onChange(job));
                    }
                    catch (JobNotFoundException jobNotFoundException) {
                        listeners.forEach(jobChangeListener -> {
                            try {
                                jobChangeListener.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void notifyBackgroundJobServerStatusChangeListeners() {
        try {
            List<BackgroundJobServerStatusChangeListener> serverChangeListeners = StreamUtils.ofType(this.onChangeListeners, BackgroundJobServerStatusChangeListener.class).collect(Collectors.toList());
            if (!serverChangeListeners.isEmpty()) {
                List<BackgroundJobServerStatus> servers = this.getBackgroundJobServers();
                serverChangeListeners.forEach(listener -> listener.onChange(servers));
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    void startTimerToSendUpdates() {
        if (this.timer == null && this.timerReentrantLock.tryLock()) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new NotifyOnChangeListeners(), 3000L, 5000L);
            this.timerReentrantLock.unlock();
        }
    }

    void stopTimerToSendUpdates() {
        if (this.timer != null && this.timerReentrantLock.tryLock()) {
            this.timer.cancel();
            this.timer = null;
            this.timerReentrantLock.unlock();
        }
    }

    private void logError(Exception e) {
        if (this.timerReentrantLock.isLocked() || this.timer == null) {
            return;
        }
        LOGGER.warn("Error notifying JobStorageChangeListeners", (Throwable)e);
    }

    class NotifyOnChangeListeners
    extends TimerTask {
        NotifyOnChangeListeners() {
        }

        @Override
        public void run() {
            AbstractStorageProvider.this.notifyJobStatsOnChangeListeners();
            AbstractStorageProvider.this.notifyJobChangeListeners();
            AbstractStorageProvider.this.notifyBackgroundJobServerStatusChangeListeners();
            AbstractStorageProvider.this.notifyMetadataChangeListeners();
        }
    }
}

