/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.jobrunr.storage.StorageException;

public class ConcurrentJobModificationException
extends StorageException {
    private final List<Job> concurrentUpdatedJobs;

    public ConcurrentJobModificationException(Job concurrentUpdatedJob) {
        this(concurrentUpdatedJob, null);
    }

    public ConcurrentJobModificationException(Job concurrentUpdatedJob, Exception cause) {
        this(Collections.singletonList(concurrentUpdatedJob), cause);
    }

    public ConcurrentJobModificationException(List<Job> concurrentUpdatedJobs) {
        this(concurrentUpdatedJobs, null);
    }

    public ConcurrentJobModificationException(List<Job> concurrentUpdatedJobs, Exception cause) {
        super("The following jobs where concurrently updated: " + ConcurrentJobModificationException.constructMessage(concurrentUpdatedJobs), cause);
        this.concurrentUpdatedJobs = concurrentUpdatedJobs;
    }

    public List<Job> getConcurrentUpdatedJobs() {
        return this.concurrentUpdatedJobs;
    }

    private static String constructMessage(List<Job> concurrentUpdatedJobs) {
        return concurrentUpdatedJobs.stream().map(job -> job.getId().toString()).collect(Collectors.joining(", "));
    }
}

