/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jobrunr.storage.navigation.PageRequest;
import org.jobrunr.utils.CollectionUtils;

public class Page<T> {
    private final Long total;
    private final int currentPage;
    private final int totalPages;
    private final int limit;
    private final long offset;
    private final boolean hasPrevious;
    private final boolean hasNext;
    private final String previousPage;
    private final String nextPage;
    private final ArrayList<T> items;

    public static Page emptyPage() {
        return new Page(0L, Collections.emptyList(), null, null, null);
    }

    public Page(long total, List<T> items, PageRequest currentPage, PageRequest previousPage, PageRequest nextPage) {
        this(total, items, -1L, -1, currentPage, previousPage, nextPage);
    }

    public Page(long total, List<T> items, long offset, int currentPageNo, PageRequest currentPage, PageRequest previousPage, PageRequest nextPage) {
        this.total = total;
        this.totalPages = Page.calculateTotalPages(total, currentPage);
        this.limit = Page.calculateLimit(currentPage);
        this.offset = offset;
        this.currentPage = currentPageNo;
        this.hasPrevious = previousPage != null;
        this.hasNext = nextPage != null;
        this.previousPage = this.hasPrevious ? previousPage.asString() : null;
        this.nextPage = this.hasNext ? nextPage.asString() : null;
        this.items = new ArrayList<T>(items);
    }

    public Long getTotal() {
        return this.total;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getPreviousPage() {
        return this.previousPage;
    }

    public String getNextPage() {
        return this.nextPage;
    }

    public List<T> getItems() {
        return this.items;
    }

    public boolean hasItems() {
        return CollectionUtils.isNotNullOrEmpty(this.items);
    }

    public boolean hasPreviousPage() {
        return this.hasPrevious;
    }

    public boolean hasNextPage() {
        return this.hasNext;
    }

    private static int calculateTotalPages(long total, PageRequest currentPageRequest) {
        if (total == 0L) {
            return 0;
        }
        int result = (int)Math.ceil((double)total / (double)currentPageRequest.getLimit());
        if ((long)(result * currentPageRequest.getLimit()) < total) {
            ++result;
        }
        return result;
    }

    private static int calculateLimit(PageRequest currentPageRequest) {
        if (currentPageRequest == null) {
            return 0;
        }
        return currentPageRequest.getLimit();
    }
}

