/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import org.jobrunr.storage.Page;
import org.jobrunr.storage.navigation.AmountRequest;
import org.jobrunr.storage.navigation.OffsetBasedPageRequest;

public class Paging {
    private Paging() {
    }

    public static class OffsetBasedPage {
        public static OffsetBasedPageRequest next(Page page) {
            return OffsetBasedPageRequest.fromString(page.getNextPage());
        }

        public static OffsetBasedPageRequest previous(Page page) {
            return OffsetBasedPageRequest.fromString(page.getPreviousPage());
        }

        public static OffsetBasedPageRequest ascOnUpdatedAt(int amount) {
            return OffsetBasedPage.ascOnUpdatedAt(0, amount);
        }

        public static OffsetBasedPageRequest ascOnUpdatedAt(int offset, int amount) {
            return new OffsetBasedPageRequest("updatedAt:ASC", offset, amount);
        }

        public static OffsetBasedPageRequest descOnUpdatedAt(int amount) {
            return OffsetBasedPage.descOnUpdatedAt(0, amount);
        }

        public static OffsetBasedPageRequest descOnUpdatedAt(int offset, int amount) {
            return new OffsetBasedPageRequest("updatedAt:DESC", offset, amount);
        }

        public static OffsetBasedPageRequest ascOnScheduledAt(int amount) {
            return OffsetBasedPage.ascOnScheduledAt(0, amount);
        }

        public static OffsetBasedPageRequest ascOnScheduledAt(int offset, int amount) {
            return new OffsetBasedPageRequest("scheduledAt:ASC", offset, amount);
        }
    }

    public static class AmountBasedList {
        public static AmountRequest ascOnUpdatedAt(int amount) {
            return new AmountRequest("updatedAt:ASC", amount);
        }

        public static AmountRequest descOnUpdatedAt(int amount) {
            return new AmountRequest("updatedAt:DESC", amount);
        }

        public static AmountRequest ascOnCreatedAt(int amount) {
            return new AmountRequest("createdAt:ASC", amount);
        }
    }
}

