/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobId;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.listeners.StorageProviderChangeListener;
import org.jobrunr.storage.navigation.AmountRequest;
import org.jobrunr.utils.resilience.Lock;
import org.jobrunr.utils.resilience.MultiLock;

public class ThreadSafeStorageProvider
implements StorageProvider {
    private final StorageProvider storageProvider;

    public ThreadSafeStorageProvider(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    @Override
    public StorageProvider.StorageProviderInfo getStorageProviderInfo() {
        return this.storageProvider.getStorageProviderInfo();
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
        this.storageProvider.setUpStorageProvider(databaseOptions);
    }

    @Override
    public void addJobStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.storageProvider.addJobStorageOnChangeListener(listener);
    }

    @Override
    public void removeJobStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.storageProvider.removeJobStorageOnChangeListener(listener);
    }

    @Override
    public void setJobMapper(JobMapper jobMapper) {
        this.storageProvider.setJobMapper(jobMapper);
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        this.storageProvider.announceBackgroundJobServer(serverStatus);
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        return this.storageProvider.signalBackgroundJobServerAlive(serverStatus);
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        this.storageProvider.signalBackgroundJobServerStopped(serverStatus);
    }

    @Override
    public List<BackgroundJobServerStatus> getBackgroundJobServers() {
        return this.storageProvider.getBackgroundJobServers();
    }

    @Override
    public UUID getLongestRunningBackgroundJobServerId() {
        return this.storageProvider.getLongestRunningBackgroundJobServerId();
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        return this.storageProvider.removeTimedOutBackgroundJobServers(heartbeatOlderThan);
    }

    @Override
    public void saveMetadata(JobRunrMetadata metadata) {
        this.storageProvider.saveMetadata(metadata);
    }

    @Override
    public List<JobRunrMetadata> getMetadata(String key) {
        return this.storageProvider.getMetadata(key);
    }

    @Override
    public JobRunrMetadata getMetadata(String key, String owner) {
        return this.storageProvider.getMetadata(key, owner);
    }

    @Override
    public void deleteMetadata(String name) {
        this.storageProvider.deleteMetadata(name);
    }

    @Override
    public Job save(Job job) {
        try (Lock lock = job.lock();){
            Job job2 = this.storageProvider.save(job);
            return job2;
        }
    }

    @Override
    public List<Job> save(List<Job> jobs) {
        try (MultiLock lock = new MultiLock(jobs);){
            List<Job> list = this.storageProvider.save(jobs);
            return list;
        }
    }

    @Override
    public int deletePermanently(UUID id) {
        return this.storageProvider.deletePermanently(id);
    }

    @Override
    public Job getJobById(UUID id) {
        return this.storageProvider.getJobById(id);
    }

    @Override
    public long countJobs(StateName state) {
        return this.storageProvider.countJobs(state);
    }

    @Override
    public List<Job> getJobList(StateName state, Instant updatedBefore, AmountRequest amountRequest) {
        return this.storageProvider.getJobList(state, updatedBefore, amountRequest);
    }

    @Override
    public List<Job> getJobList(StateName state, AmountRequest amountRequest) {
        return this.storageProvider.getJobList(state, amountRequest);
    }

    @Override
    public List<Job> getScheduledJobs(Instant scheduledBefore, AmountRequest amountRequest) {
        return this.storageProvider.getScheduledJobs(scheduledBefore, amountRequest);
    }

    @Override
    public List<Job> getJobsToProcess(BackgroundJobServer backgroundJobServer, AmountRequest amountRequest) {
        return this.storageProvider.getJobsToProcess(backgroundJobServer, amountRequest);
    }

    @Override
    public int deleteJobsPermanently(StateName state, Instant updatedBefore) {
        return this.storageProvider.deleteJobsPermanently(state, updatedBefore);
    }

    @Override
    public Set<String> getDistinctJobSignatures(StateName ... states) {
        return this.storageProvider.getDistinctJobSignatures(states);
    }

    @Override
    public boolean recurringJobExists(String recurringJobId, StateName ... states) {
        return this.storageProvider.recurringJobExists(recurringJobId, states);
    }

    @Override
    public RecurringJob saveRecurringJob(RecurringJob recurringJob) {
        return this.storageProvider.saveRecurringJob(recurringJob);
    }

    @Override
    public RecurringJobsResult getRecurringJobs() {
        return this.storageProvider.getRecurringJobs();
    }

    @Override
    public boolean recurringJobsUpdated(Long recurringJobsUpdatedHash) {
        return this.storageProvider.recurringJobsUpdated(recurringJobsUpdatedHash);
    }

    @Override
    public int deleteRecurringJob(String id) {
        return this.storageProvider.deleteRecurringJob(id);
    }

    @Override
    public JobStats getJobStats() {
        return this.storageProvider.getJobStats();
    }

    @Override
    public void publishTotalAmountOfSucceededJobs(int amount) {
        this.storageProvider.publishTotalAmountOfSucceededJobs(amount);
    }

    @Override
    public Job getJobById(JobId jobId) {
        return this.storageProvider.getJobById(jobId);
    }

    @Override
    public void close() {
        this.storageProvider.close();
    }

    @Override
    public void validatePollInterval(Duration pollInterval) {
        this.storageProvider.validatePollInterval(pollInterval);
    }

    @Override
    public void validateRecurringJobInterval(Duration durationBetweenRecurringJobInstances) {
        this.storageProvider.validateRecurringJobInterval(durationBetweenRecurringJobInstances);
    }

    public StorageProvider getStorageProvider() {
        return this.storageProvider;
    }
}

