/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jobrunr.storage.navigation.OrderTerm;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.annotations.VisibleFor;

public class AmountRequest {
    public static final int DEFAULT_LIMIT = 20;
    protected final String order;
    protected final int limit;

    public static AmountRequest fromString(String amountRequestAsString) {
        if (StringUtils.isNullOrEmpty(amountRequestAsString)) {
            return null;
        }
        return new AmountRequest(StringUtils.lenientSubstringBetween(amountRequestAsString, "order=", "&"), Integer.parseInt(StringUtils.lenientSubstringBetween(amountRequestAsString, "limit=", "&")));
    }

    public AmountRequest(String order, int limit) {
        this.order = StringUtils.isNotNullOrEmpty(order) ? order : "updatedAt:ASC";
        this.limit = limit;
    }

    public String getOrder() {
        return this.order;
    }

    public int getLimit() {
        return this.limit;
    }

    public String asString() {
        return "order=" + this.getOrder() + "&limit=" + this.getLimit();
    }

    @VisibleFor(value="testing")
    public List<OrderTerm> getAllOrderTerms(Set<String> allowedOrderTerms) {
        if (StringUtils.isNullOrEmpty(this.order)) {
            return Collections.emptyList();
        }
        String[] sortOns = this.order.split(",");
        ArrayList<OrderTerm> result = new ArrayList<OrderTerm>();
        for (String sortOn : sortOns) {
            String sortField = this.sortField(sortOn);
            if (!allowedOrderTerms.contains(sortField)) continue;
            OrderTerm.Order sortOrder = this.sortOrder(sortOn);
            result.add(new OrderTerm(sortField, sortOrder));
        }
        return result;
    }

    private String sortField(String sortOn) {
        return StringUtils.substringBefore(sortOn, ":");
    }

    private OrderTerm.Order sortOrder(String sortOn) {
        String sortOrder = StringUtils.substringAfter(sortOn, ":");
        if (sortOrder == null) {
            return OrderTerm.Order.ASC;
        }
        return OrderTerm.Order.valueOf(sortOrder.toUpperCase());
    }
}

