/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.navigation;

import java.util.Collections;
import java.util.List;
import org.jobrunr.storage.Page;
import org.jobrunr.storage.navigation.PageRequest;
import org.jobrunr.utils.StringUtils;

public class OffsetBasedPageRequest
extends PageRequest {
    public static final Page emptyPage = new Page(0L, Collections.emptyList(), 0L, 0, null, null, null);
    public static final long DEFAULT_OFFSET = 0L;
    private final long offset;

    OffsetBasedPageRequest() {
        this(null, 0L, 20);
    }

    public OffsetBasedPageRequest(String order, long offset, int limit) {
        super(order, limit);
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public String asString() {
        return "order=" + this.getOrder() + "&offset=" + this.offset + "&limit=" + this.getLimit();
    }

    public static OffsetBasedPageRequest fromString(String offsetBasedPageRequestAsString) {
        if (StringUtils.isNullOrEmpty(offsetBasedPageRequestAsString)) {
            return null;
        }
        String order = StringUtils.lenientSubstringBetween(offsetBasedPageRequestAsString, "order=", "&");
        String offset = StringUtils.lenientSubstringBetween(offsetBasedPageRequestAsString, "offset=", "&");
        String limit = StringUtils.lenientSubstringBetween(offsetBasedPageRequestAsString, "limit=", "&");
        return new OffsetBasedPageRequest(order, StringUtils.isNotNullOrEmpty(offset) ? (long)Integer.parseInt(offset) : 0L, StringUtils.isNotNullOrEmpty(limit) ? Integer.parseInt(limit) : 20);
    }

    @Override
    public <T> Page<T> mapToNewPage(long total, List<T> items) {
        return new Page<T>(total, items, this.offset, this.calculateCurrentPage(), this, this.previousPageRequest(total), this.nextPageRequest(total));
    }

    @Override
    public <T> Page<T> emptyPage() {
        return new Page(0L, Collections.emptyList(), this.offset, 0, this, null, null);
    }

    private OffsetBasedPageRequest previousPageRequest(long ignored) {
        if (this.getOffset() >= (long)this.getLimit()) {
            return new OffsetBasedPageRequest(this.getOrder(), this.getOffset() - (long)this.getLimit(), this.getLimit());
        }
        return null;
    }

    private OffsetBasedPageRequest nextPageRequest(long total) {
        if (total > this.getOffset() + (long)this.getLimit()) {
            return new OffsetBasedPageRequest(this.getOrder(), this.getOffset() + (long)this.getLimit(), this.getLimit());
        }
        return null;
    }

    private int calculateCurrentPage() {
        int result = (int)Math.floor((double)this.offset / (double)this.limit);
        if (result < 1 && this.offset > 0L) {
            return 1;
        }
        return result;
    }
}

