/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jobrunr.JobRunrException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.common.NoSqlDatabaseCreator;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;
import org.jobrunr.utils.StringUtils;

public class ElasticSearchDBCreator
extends NoSqlDatabaseCreator<ElasticSearchMigration> {
    public static final String JOBRUNR_MIGRATIONS_INDEX_NAME = "jobrunr_migrations";
    private final ElasticsearchClient client;
    private final String indexPrefix;
    private final String migrationIndexName;

    public ElasticSearchDBCreator(NoSqlStorageProvider noSqlStorageProvider, ElasticsearchClient client, String indexPrefix) {
        super(noSqlStorageProvider);
        this.client = client;
        this.indexPrefix = indexPrefix;
        this.migrationIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, JOBRUNR_MIGRATIONS_INDEX_NAME);
        ElasticSearchMigration.waitForHealthyCluster(client);
    }

    @Override
    public void runMigrations() {
        this.createMigrationsIndexIfNotExists();
        super.runMigrations();
    }

    public void validateIndices() {
        try {
            ElasticSearchMigration.waitForHealthyCluster(this.client);
            List<String> requiredIndexNames = Arrays.asList("jobs", "recurring_jobs", "background_job_servers", "metadata");
            Set availableIndexNames = this.client.indices().get(r -> r.index("*", new String[0])).result().keySet();
            for (String requiredIndexName : requiredIndexNames) {
                if (availableIndexNames.contains(StorageProviderUtils.elementPrefixer(this.indexPrefix, StorageProviderUtils.elementPrefixer("jobrunr_", requiredIndexName)))) continue;
                throw new JobRunrException("Not all required indices are available by JobRunr!");
            }
        }
        catch (ElasticsearchException e) {
            if (e.status() == 404) {
                throw new JobRunrException("Not all required indices are available by JobRunr!");
            }
            throw new StorageException(e);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private void createMigrationsIndexIfNotExists() {
        if (ElasticSearchMigration.indexExists(this.client, this.migrationIndexName)) {
            return;
        }
        ElasticSearchMigration.createIndex(this.client, this.migrationIndexName);
    }

    @Override
    protected boolean isNewMigration(NoSqlMigration noSqlMigration) {
        return this.isNewMigration(noSqlMigration, 0);
    }

    @Override
    protected void runMigration(ElasticSearchMigration noSqlMigration) throws IOException {
        noSqlMigration.runMigration(this.client, this.indexPrefix);
    }

    @Override
    protected boolean markMigrationAsDone(NoSqlMigration noSqlMigration) {
        try {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", noSqlMigration.getClassName());
            map.put("date", Instant.now().toEpochMilli());
            return this.client.index(r -> r.index(this.migrationIndexName).id(StringUtils.substringBefore(noSqlMigration.getClassName(), "_")).refresh(Refresh.True).document((Object)map)).result() != null;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private boolean isNewMigration(NoSqlMigration noSqlMigration, int retry) {
        ElasticSearchUtils.sleep((long)retry * 500L);
        try {
            ElasticSearchMigration.waitForHealthyCluster(this.client);
            BooleanResponse migration = this.client.exists(r -> r.index(this.migrationIndexName).id(StringUtils.substringBefore(noSqlMigration.getClassName(), "_")));
            return !migration.value();
        }
        catch (ElasticsearchException e) {
            if (retry < 5) {
                return this.isNewMigration(noSqlMigration, retry + 1);
            }
            if (e.status() == 404) {
                return true;
            }
            throw e;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }
}

