/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch;

import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.json.JsonData;
import jakarta.json.JsonString;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class ElasticSearchDocumentMapper {
    private final JobMapper jobMapper;

    public ElasticSearchDocumentMapper(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }

    public Map<Object, Object> toMap(BackgroundJobServerStatus serverStatus) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put("id", serverStatus.getId().toString());
        map.put("name", serverStatus.getName().toString());
        map.put("workerPoolSize", serverStatus.getWorkerPoolSize());
        map.put("pollIntervalInSeconds", serverStatus.getPollIntervalInSeconds());
        map.put("deleteSucceededJobsAfter", serverStatus.getDeleteSucceededJobsAfter().toString());
        map.put("permanentlyDeleteDeletedJobsAfter", serverStatus.getPermanentlyDeleteDeletedJobsAfter().toString());
        map.put("firstHeartbeat", serverStatus.getFirstHeartbeat().toEpochMilli());
        map.put("lastHeartbeat", serverStatus.getLastHeartbeat().toEpochMilli());
        map.put("running", serverStatus.isRunning());
        map.put("systemTotalMemory", serverStatus.getSystemTotalMemory());
        map.put("systemFreeMemory", serverStatus.getSystemFreeMemory());
        map.put("systemCpuLoad", serverStatus.getSystemCpuLoad());
        map.put("processMaxMemory", serverStatus.getProcessMaxMemory());
        map.put("processFreeMemory", serverStatus.getProcessFreeMemory());
        map.put("processAllocatedMemory", serverStatus.getProcessAllocatedMemory());
        map.put("processCpuLoad", serverStatus.getProcessCpuLoad());
        return map;
    }

    public Map<Object, Object> toMapForUpdate(BackgroundJobServerStatus serverStatus) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put("lastHeartbeat", serverStatus.getLastHeartbeat().toEpochMilli());
        map.put("systemFreeMemory", serverStatus.getSystemFreeMemory());
        map.put("systemCpuLoad", serverStatus.getSystemCpuLoad());
        map.put("processFreeMemory", serverStatus.getProcessFreeMemory());
        map.put("processAllocatedMemory", serverStatus.getProcessAllocatedMemory());
        map.put("processCpuLoad", serverStatus.getProcessCpuLoad());
        return map;
    }

    public Map<Object, Object> toMap(Job job) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put("jobAsJson", this.jobMapper.serializeJob(job));
        map.put("state", (Object)job.getState());
        map.put("updatedAt", job.getUpdatedAt().toEpochMilli());
        map.put("jobSignature", job.getJobSignature());
        if (job.hasState(StateName.SCHEDULED)) {
            Instant instant = job.getLastJobStateOfType(ScheduledState.class).map(ScheduledState::getScheduledAt).orElseThrow(IllegalStateException::new);
            map.put("scheduledAt", instant.toEpochMilli());
        }
        if (job.getRecurringJobId().isPresent()) {
            map.put("recurringJobId", job.getRecurringJobId().get());
        }
        return map;
    }

    public Map<Object, Object> toMap(JobRunrMetadata metadata) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put("name", metadata.getName());
        map.put("owner", metadata.getOwner());
        map.put("value", metadata.getValue());
        map.put("createdAt", metadata.getCreatedAt().toEpochMilli());
        map.put("updatedAt", metadata.getUpdatedAt().toEpochMilli());
        return map;
    }

    public Map<Object, Object> toMap(RecurringJob job) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put("jobAsJson", this.jobMapper.serializeRecurringJob(job));
        map.put("createdAt", job.getCreatedAt().toEpochMilli());
        return map;
    }

    public BackgroundJobServerStatus toBackgroundJobServerStatus(Map<Object, Object> map) {
        return new BackgroundJobServerStatus(ReflectionUtils.autobox(map.get("id"), UUID.class), ReflectionUtils.autobox(map.get("name"), String.class), ReflectionUtils.autobox(map.get("workerPoolSize"), Integer.TYPE), ReflectionUtils.autobox(map.get("pollIntervalInSeconds"), Integer.TYPE), ReflectionUtils.autobox(map.get("deleteSucceededJobsAfter"), Duration.class), ReflectionUtils.autobox(map.get("permanentlyDeleteDeletedJobsAfter"), Duration.class), ReflectionUtils.autobox(map.get("firstHeartbeat"), Instant.class), ReflectionUtils.autobox(map.get("lastHeartbeat"), Instant.class), ReflectionUtils.autobox(map.get("running"), Boolean.TYPE), ReflectionUtils.autobox(map.get("systemTotalMemory"), Long.TYPE), ReflectionUtils.autobox(map.get("systemFreeMemory"), Long.TYPE), ReflectionUtils.autobox(map.get("systemCpuLoad"), Double.TYPE), ReflectionUtils.autobox(map.get("processMaxMemory"), Long.TYPE), ReflectionUtils.autobox(map.get("processFreeMemory"), Long.TYPE), ReflectionUtils.autobox(map.get("processAllocatedMemory"), Long.TYPE), ReflectionUtils.autobox(map.get("processCpuLoad"), Double.TYPE));
    }

    public JobRunrMetadata toMetadata(Map<Object, Object> fieldMap) {
        if (fieldMap == null || fieldMap.isEmpty()) {
            return null;
        }
        return new JobRunrMetadata(ReflectionUtils.autobox(fieldMap.get("name"), String.class), ReflectionUtils.autobox(fieldMap.get("owner"), String.class), ReflectionUtils.autobox(fieldMap.get("value"), String.class), ReflectionUtils.autobox(fieldMap.get("createdAt"), Instant.class), ReflectionUtils.autobox(fieldMap.get("updatedAt"), Instant.class));
    }

    public Job toJob(GetResponse<Map> response) {
        JsonData jsonData = (JsonData)response.fields().get("jobAsJson");
        String jobAsJson = ((JsonString)jsonData.toJson().asJsonArray().get(0)).getString();
        return this.jobMapper.deserializeJob(jobAsJson);
    }

    public Job toJob(Hit<Map> hit) {
        JsonData jsonData = (JsonData)hit.fields().get("jobAsJson");
        String jobAsJson = ((JsonString)jsonData.toJson().asJsonArray().get(0)).getString();
        return this.jobMapper.deserializeJob(jobAsJson);
    }

    public RecurringJob toRecurringJob(Hit<?> hit) {
        JsonData jsonData = (JsonData)hit.fields().get("jobAsJson");
        String jobAsJson = ((JsonString)jsonData.toJson().asJsonArray().get(0)).getString();
        return this.jobMapper.deserializeRecurringJob(jobAsJson);
    }
}

