/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.InlineScript;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.ScriptBuilders;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.SumAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.CountResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobListVersioner;
import org.jobrunr.jobs.JobVersioner;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.AbstractStorageProvider;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.storage.ServerTimedOutException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.navigation.AmountRequest;
import org.jobrunr.storage.navigation.OffsetBasedPageRequest;
import org.jobrunr.storage.navigation.OrderTerm;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchDBCreator;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchDocumentMapper;
import org.jobrunr.utils.annotations.Beta;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.resilience.RateLimiter;

@Beta(note="The ElasticSearchStorageProvider is still in Beta. My first impression is that other StorageProviders are faster than ElasticSearch.")
public class ElasticSearchStorageProvider
extends AbstractStorageProvider
implements NoSqlStorageProvider {
    private static final Class<Map> MAP_CLASS = Map.class;
    public static final String DEFAULT_JOB_INDEX_NAME = "jobrunr_jobs";
    public static final String DEFAULT_RECURRING_JOB_INDEX_NAME = "jobrunr_recurring_jobs";
    public static final String DEFAULT_BACKGROUND_JOB_SERVER_INDEX_NAME = "jobrunr_background_job_servers";
    public static final String DEFAULT_METADATA_INDEX_NAME = "jobrunr_metadata";
    public static final int MAX_SIZE = 10000;
    private final ElasticsearchClient client;
    private final String jobIndexName;
    private final String recurringJobIndexName;
    private final String backgroundJobServerIndexName;
    private final String metadataIndexName;
    private final String indexPrefix;
    private ElasticSearchDocumentMapper documentMapper;

    public ElasticSearchStorageProvider(String hostName, int port) {
        this(new HttpHost(hostName, port, "http"));
    }

    public ElasticSearchStorageProvider(HttpHost httpHost) {
        this(ElasticSearchStorageProvider.newClient(httpHost));
    }

    public ElasticSearchStorageProvider(ElasticsearchClient client) {
        this(client, (String)null);
    }

    public ElasticSearchStorageProvider(ElasticsearchClient client, String indexPrefix) {
        this(client, indexPrefix, StorageProviderUtils.DatabaseOptions.CREATE, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public ElasticSearchStorageProvider(ElasticsearchClient client, String indexPrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(client, indexPrefix, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public ElasticSearchStorageProvider(ElasticsearchClient client, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(client, null, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public ElasticSearchStorageProvider(ElasticsearchClient client, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter rateLimiter) {
        this(client, null, databaseOptions, rateLimiter);
    }

    public ElasticSearchStorageProvider(ElasticsearchClient client, String indexPrefix, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit) {
        super(changeListenerNotificationRateLimit);
        this.client = client;
        this.indexPrefix = indexPrefix;
        this.setUpStorageProvider(databaseOptions);
        this.jobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_JOB_INDEX_NAME);
        this.recurringJobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_RECURRING_JOB_INDEX_NAME);
        this.backgroundJobServerIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_BACKGROUND_JOB_SERVER_INDEX_NAME);
        this.metadataIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_METADATA_INDEX_NAME);
    }

    @Override
    public void setJobMapper(JobMapper jobMapper) {
        this.documentMapper = new ElasticSearchDocumentMapper(jobMapper);
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions options) {
        ElasticSearchDBCreator creator = new ElasticSearchDBCreator(this, this.client, this.indexPrefix);
        if (StorageProviderUtils.DatabaseOptions.CREATE == options) {
            creator.runMigrations();
        } else {
            creator.validateIndices();
        }
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus status) {
        try {
            this.client.index(r -> r.index(this.backgroundJobServerIndexName).id(status.getId().toString()).refresh(Refresh.True).document(this.documentMapper.toMap(status)));
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus status) {
        try {
            Map<Object, Object> value = this.documentMapper.toMapForUpdate(status);
            UpdateResponse response = this.client.update(r -> r.index(this.backgroundJobServerIndexName).id(status.getId().toString()).refresh(Refresh.True).source(s -> s.fetch(Boolean.valueOf(true))).doc((Object)value), value.getClass());
            Map source = (Map)ReflectionUtils.cast(response.get().source());
            return (Boolean)ReflectionUtils.cast(source.getOrDefault("running", false));
        }
        catch (ElasticsearchException e) {
            if (e.status() == 404) {
                throw new ServerTimedOutException(status, new StorageException(e));
            }
            throw e;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus status) {
        try {
            String id = status.getId().toString();
            this.client.delete(d -> d.index(this.backgroundJobServerIndexName).id(id).refresh(Refresh.True));
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<BackgroundJobServerStatus> getBackgroundJobServers() {
        try {
            SearchResponse search = this.client.search(s -> s.index(this.backgroundJobServerIndexName, new String[0]).query(q -> q.matchAll(m -> m)).sort(sort -> sort.field(f -> f.field("firstHeartbeat").order(SortOrder.Asc))).source(src -> src.fetch(Boolean.valueOf(true))).size(Integer.valueOf(10000)), MAP_CLASS);
            return search.hits().hits().stream().map(Hit::source).filter(Objects::nonNull).map(this.documentMapper::toBackgroundJobServerStatus).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public UUID getLongestRunningBackgroundJobServerId() {
        try {
            SearchResponse search = this.client.search(s -> s.index(this.backgroundJobServerIndexName, new String[0]).query(q -> q.matchAll(m -> m)).source(src -> src.fetch(Boolean.valueOf(false))).sort(sort -> sort.field(f -> f.field("firstHeartbeat").order(SortOrder.Asc))).size(Integer.valueOf(1)), MAP_CLASS);
            return UUID.fromString(((Hit)search.hits().hits().get(0)).id());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        RangeQuery q = RangeQuery.of(r -> r.field("lastHeartbeat").to(Long.toString(heartbeatOlderThan.toEpochMilli())));
        long deleted = this.deleteByQuery(this.backgroundJobServerIndexName, (QueryVariant)q);
        this.notifyJobStatsOnChangeListenersIf(deleted > 0L);
        return (int)deleted;
    }

    @Override
    public void saveMetadata(JobRunrMetadata metadata) {
        try {
            this.client.index(i -> i.index(this.metadataIndexName).id(metadata.getId()).refresh(Refresh.True).document(this.documentMapper.toMap(metadata)));
            this.notifyMetadataChangeListeners();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<JobRunrMetadata> getMetadata(String name) {
        try {
            SearchResponse response = this.client.search(s -> s.index(this.metadataIndexName, new String[0]).query(q -> q.match(m -> m.field("name").query(name))).source(src -> src.fetch(Boolean.valueOf(true))).size(Integer.valueOf(10000)), MAP_CLASS);
            return response.hits().hits().stream().map(Hit::source).map(this.documentMapper::toMetadata).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public JobRunrMetadata getMetadata(String name, String owner) {
        try {
            GetResponse response = this.client.get(g -> g.index(this.metadataIndexName).id(JobRunrMetadata.toId(name, owner)), MAP_CLASS);
            Map source = Optional.ofNullable((Map)response.source()).orElse(Collections.EMPTY_MAP);
            return this.documentMapper.toMetadata(source);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void deleteMetadata(String name) {
        MatchQuery q = MatchQuery.of(m -> m.field("name").query(name));
        long deleted = this.deleteByQuery(this.metadataIndexName, (QueryVariant)q);
        if (deleted > 0L) {
            this.notifyMetadataChangeListeners();
        }
    }

    private long deleteByQuery(String index, QueryVariant query) {
        try {
            DeleteByQueryResponse response = this.client.deleteByQuery(d -> d.index(index, new String[0]).query(query._toQuery()).refresh(Boolean.valueOf(true)));
            return response.deleted();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Job save(Job job) {
        JobVersioner jobVersioner = new JobVersioner(job);
        try {
            this.client.index(i -> i.index(this.jobIndexName).id(job.getId().toString()).versionType(VersionType.External).version(Long.valueOf(job.getVersion())).document(this.documentMapper.toMap(job)).refresh(Refresh.True));
            jobVersioner.commitVersion();
            this.notifyJobStatsOnChangeListeners();
            Job job2 = job;
            jobVersioner.close();
            return job2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jobVersioner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ResponseException e) {
                if (e.getResponse().getStatusLine() != null && e.getResponse().getStatusLine().getStatusCode() == 409) {
                    throw new ConcurrentJobModificationException(job);
                }
                throw new StorageException(e);
            }
            catch (ElasticsearchException | IOException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    public int deletePermanently(UUID id) {
        try {
            DeleteResponse response = this.client.delete(d -> d.index(this.jobIndexName).id(id.toString()).refresh(Refresh.True));
            int amountDeleted = response.shards().successful().intValue();
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Job getJobById(UUID id) {
        try {
            GetResponse response = this.client.get(r -> r.index(this.jobIndexName).id(id.toString()).storedFields("jobAsJson", new String[0]), MAP_CLASS);
            if (response.found()) {
                return this.documentMapper.toJob((GetResponse<Map>)response);
            }
            throw new JobNotFoundException(id);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public long countJobs(StateName state) {
        try {
            BoolQuery query = QueryBuilders.bool().must(must -> must.match(match -> match.field("state").query(state.toString()))).build();
            return this.countJobs((QueryVariant)query);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Job> getJobList(StateName state, Instant updatedBefore, AmountRequest amountRequest) {
        QueryVariant query = ElasticSearchStorageProvider.withStateAndUpdatedBefore(state, updatedBefore);
        return this.findJobs(query, amountRequest);
    }

    @Override
    public List<Job> getJobList(StateName state, AmountRequest amountRequest) {
        BoolQuery query = QueryBuilders.bool().must(must -> must.match(match -> match.field("state").query(state.toString()))).build();
        return this.findJobs((QueryVariant)query, amountRequest);
    }

    @Override
    public List<Job> getScheduledJobs(Instant scheduledBefore, AmountRequest amountRequest) {
        RangeQuery query = QueryBuilders.range().field("scheduledAt").to(Long.toString(scheduledBefore.toEpochMilli())).build();
        return this.findJobs((QueryVariant)query, amountRequest);
    }

    @Override
    public List<Job> save(List<Job> jobs) {
        JobListVersioner versioner = new JobListVersioner(jobs);
        try {
            versioner.validateJobs();
            BulkRequest.Builder bulk = new BulkRequest.Builder().index(this.jobIndexName).refresh(Refresh.True);
            ArrayList<BulkOperation> operations = new ArrayList<BulkOperation>();
            for (Job job : jobs) {
                IndexOperation.Builder builder = ((IndexOperation.Builder)((IndexOperation.Builder)((IndexOperation.Builder)new IndexOperation.Builder().id(job.getId().toString())).versionType(VersionType.External)).version(Long.valueOf(job.getVersion()))).document(this.documentMapper.toMap(job));
                operations.add(builder.build()._toBulkOperation());
            }
            bulk.operations(operations);
            BulkResponse response = this.client.bulk(bulk.build());
            if (response.errors()) {
                ArrayList<Job> concurrentModifiedJobs = new ArrayList<Job>();
                List items = response.items();
                for (int i = 0; i < response.items().size(); ++i) {
                    if (((BulkResponseItem)items.get(i)).status() != 409) continue;
                    concurrentModifiedJobs.add(jobs.get(i));
                }
                if (!concurrentModifiedJobs.isEmpty()) {
                    versioner.rollbackVersions(concurrentModifiedJobs);
                    throw new ConcurrentJobModificationException(concurrentModifiedJobs);
                }
                throw new StorageException("Could not save all jobs");
            }
            versioner.commitVersions();
            this.notifyJobStatsOnChangeListenersIf(!jobs.isEmpty());
            List<Job> list = jobs;
            versioner.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    versioner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ElasticsearchException | IOException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    public int deleteJobsPermanently(StateName state, Instant updatedBefore) {
        try {
            QueryVariant query = ElasticSearchStorageProvider.withStateAndUpdatedBefore(state, updatedBefore);
            DeleteByQueryResponse response = this.client.deleteByQuery(d -> d.index(this.jobIndexName, new String[0]).query(query._toQuery()).refresh(Boolean.valueOf(true)));
            int amountDeleted = response.deleted().intValue();
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private static QueryVariant withStateAndUpdatedBefore(StateName state, Instant updatedBefore) {
        return QueryBuilders.bool().must(must -> must.match(m -> m.field("state").query(String.valueOf((Object)state)))).must(must -> must.range(m -> m.field("updatedAt").to(Long.toString(updatedBefore.toEpochMilli())))).build();
    }

    @Override
    public Set<String> getDistinctJobSignatures(StateName ... states) {
        try {
            SearchResponse response = this.client.search(s -> s.index(this.jobIndexName, new String[0]).query(ElasticSearchStorageProvider.shouldMatch(states)).aggregations("jobSignature", t -> t.terms(terms -> terms.field("jobSignature"))).size(Integer.valueOf(0)), MAP_CLASS);
            StringTermsAggregate terms = ((Aggregate)response.aggregations().get("jobSignature")).sterms();
            return terms.buckets().array().stream().map(StringTermsBucket::key).map(FieldValue::stringValue).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean recurringJobExists(String recurringJobId, StateName ... states) {
        try {
            BoolQuery query = QueryBuilders.bool().must(ElasticSearchStorageProvider.shouldMatch(states), new Query[0]).must(mu -> mu.match(ma -> ma.field("recurringJobId").query(recurringJobId))).build();
            return this.countJobs((QueryVariant)query) > 0L;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public RecurringJob saveRecurringJob(RecurringJob job) {
        try {
            this.client.index(i -> i.index(this.recurringJobIndexName).id(job.getId()).document(this.documentMapper.toMap(job)).refresh(Refresh.True));
            return job;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public RecurringJobsResult getRecurringJobs() {
        try {
            SearchResponse response = this.client.search(s -> s.index(this.recurringJobIndexName, new String[0]).query(q -> q.matchAll(m -> m)).storedFields("jobAsJson", new String[0]).size(Integer.valueOf(10000)), MAP_CLASS);
            List<RecurringJob> jobs = response.hits().hits().stream().map(this.documentMapper::toRecurringJob).collect(Collectors.toList());
            return new RecurringJobsResult((Collection<RecurringJob>)jobs);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean recurringJobsUpdated(Long recurringJobsUpdatedHash) {
        try {
            SearchResponse response = this.client.search(s -> s.index(this.recurringJobIndexName, new String[0]).query(q -> q.matchAll(m -> m)).aggregations("createdAt", aggs -> aggs.sum(sum -> (ObjectBuilder)sum.field("createdAt"))).size(Integer.valueOf(0)), MAP_CLASS);
            SumAggregate parsedSum = ((Aggregate)response.aggregations().get("createdAt")).sum();
            return !recurringJobsUpdatedHash.equals(Double.valueOf(parsedSum.value()).longValue());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int deleteRecurringJob(String id) {
        try {
            DeleteResponse response = this.client.delete(d -> d.index(this.recurringJobIndexName).id(id).refresh(Refresh.True));
            int amountDeleted = response.shards().successful().intValue();
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public JobStats getJobStats() {
        try {
            SearchResponse response = this.client.search(s -> s.index(this.jobIndexName, new String[0]).size(Integer.valueOf(0)).query(q -> q.matchAll(m -> m)).aggregations("state", aggs -> aggs.terms(t -> t.field("state"))), MAP_CLASS);
            StringTermsAggregate terms = ((Aggregate)response.aggregations().get("state")).sterms();
            List buckets = terms.buckets().array();
            long allTimeSucceededJobs = this.getAllTimeSucceededJobs();
            int recurringJobs = this.getCount(this.recurringJobIndexName);
            int backgroundJobServers = this.getCount(this.backgroundJobServerIndexName);
            Instant now = Instant.now();
            return new JobStats(now, 0L, this.count(buckets, StateName.SCHEDULED), this.count(buckets, StateName.ENQUEUED), this.count(buckets, StateName.PROCESSING), this.count(buckets, StateName.FAILED), this.count(buckets, StateName.SUCCEEDED), allTimeSucceededJobs, this.count(buckets, StateName.DELETED), recurringJobs, backgroundJobServers);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private long getAllTimeSucceededJobs() throws IOException {
        GetResponse response = this.client.get(g -> g.index(this.metadataIndexName).id("succeeded-jobs-counter-cluster"), MAP_CLASS);
        Long value = Optional.ofNullable((Map)response.source()).orElse(Collections.EMPTY_MAP).getOrDefault("value", 0L);
        return ((Number)value).longValue();
    }

    private int getCount(String indexName) throws IOException {
        return (int)this.client.count(c -> c.index(indexName, new String[0])).count();
    }

    private long count(List<StringTermsBucket> buckets, StateName state) {
        return buckets.stream().filter(bucket -> Objects.equals(state.name(), bucket.key().stringValue())).map(MultiBucketBase::docCount).findFirst().orElse(0L);
    }

    @Override
    public void publishTotalAmountOfSucceededJobs(int amount) {
        try {
            Map<String, JsonData> parameters = Collections.singletonMap("value", JsonData.of((Object)amount));
            InlineScript inline = ((InlineScript.Builder)ScriptBuilders.inline().lang("painless").source("ctx._source.value += params.value").params(parameters)).build();
            this.client.update(u -> u.index(this.metadataIndexName).id("succeeded-jobs-counter-cluster").scriptedUpsert(Boolean.valueOf(true)).script(s -> s.inline(inline)), parameters.getClass());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    long countJobs(QueryVariant query) throws IOException {
        CountResponse response = this.client.count(c -> c.index(this.jobIndexName, new String[0]).query(query._toQuery()));
        return response.count();
    }

    private List<Job> findJobs(QueryVariant query, AmountRequest amountRequest) {
        try {
            return this.client.search(s -> s.index(this.jobIndexName, new String[0]).query(query._toQuery()).from(Integer.valueOf(amountRequest instanceof OffsetBasedPageRequest ? (int)((OffsetBasedPageRequest)amountRequest).getOffset() : 0)).size(Integer.valueOf(amountRequest.getLimit())).storedFields("jobAsJson", new String[0]).sort(ElasticSearchStorageProvider.sortJobs(amountRequest)), MAP_CLASS).hits().hits().stream().map(this.documentMapper::toJob).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private static Query shouldMatch(StateName ... states) {
        BoolQuery.Builder query = new BoolQuery.Builder();
        for (StateName state : states) {
            query.should(s -> s.match(m -> m.field("state").query(state.toString())));
        }
        return query.build()._toQuery();
    }

    private static List<SortOptions> sortJobs(AmountRequest amountRequest) {
        ArrayList<SortOptions> sortOptions = new ArrayList<SortOptions>();
        List<OrderTerm> orderTerms = amountRequest.getAllOrderTerms(Job.ALLOWED_SORT_COLUMNS.keySet());
        for (OrderTerm orderTerm : orderTerms) {
            sortOptions.add((SortOptions)new SortOptions.Builder().field(f -> f.field(orderTerm.getFieldName()).order(OrderTerm.Order.ASC == orderTerm.getOrder() ? SortOrder.Asc : SortOrder.Desc)).build());
        }
        return sortOptions;
    }

    private static ElasticsearchClient newClient(HttpHost host) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{host});
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        RestClientTransport transport = new RestClientTransport(builder.build(), (JsonpMapper)mapper);
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }
}

