/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.PutMappingRequest;
import java.io.IOException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchUtils;

public abstract class ElasticSearchMigration {
    public abstract void runMigration(ElasticsearchClient var1, String var2) throws IOException;

    public static void waitForHealthyCluster(ElasticsearchClient client) {
        try {
            client.cluster().health(r -> r.waitForStatus(HealthStatus.Yellow));
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public static boolean indexExists(ElasticsearchClient client, String name) {
        ElasticSearchMigration.waitForHealthyCluster(client);
        try {
            return client.indices().exists(r -> r.index(name, new String[0])).value();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public static void createIndex(ElasticsearchClient client, String name) {
        ElasticSearchMigration.createIndex(client, new CreateIndexRequest.Builder().index(name).build(), 0);
    }

    public static void createIndex(ElasticsearchClient client, CreateIndexRequest request) {
        ElasticSearchMigration.createIndex(client, request, 0);
    }

    private static void createIndex(ElasticsearchClient client, CreateIndexRequest request, int retry) {
        ElasticSearchUtils.sleep((long)retry * 500L);
        try {
            ElasticSearchMigration.waitForHealthyCluster(client);
            client.indices().create(request);
            ElasticSearchMigration.waitForHealthyCluster(client);
        }
        catch (ElasticsearchException e) {
            if (e.status() == 400) {
                if (e.getMessage().contains("resource_already_exists_exception")) {
                    return;
                }
                if (e.status() == 400 && retry < 5) {
                    ElasticSearchMigration.createIndex(client, request, retry + 1);
                }
                throw new StorageException("Retried 5 times to setup ElasticSearch Indices", e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    void deleteIndex(ElasticsearchClient client, String name) throws IOException {
        try {
            ElasticSearchMigration.waitForHealthyCluster(client);
            client.indices().delete(r -> r.index(name, new String[0]));
            ElasticSearchMigration.waitForHealthyCluster(client);
        }
        catch (ElasticsearchException e) {
            if (e.status() == 404) {
                return;
            }
            throw e;
        }
    }

    public static void updateIndex(ElasticsearchClient client, PutMappingRequest request) {
        try {
            ElasticSearchMigration.waitForHealthyCluster(client);
            client.indices().putMapping(request);
            ElasticSearchMigration.waitForHealthyCluster(client);
        }
        catch (ElasticsearchException e) {
            if (e.status() == 400) {
                if (e.getMessage().contains("resource_already_exists_exception")) {
                    return;
                }
                throw new StorageException("Retried 5 times to setup ElasticSearch Indices", e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }
}

