/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;

public class M001_CreateJobsIndex
extends ElasticSearchMigration {
    @Override
    public void runMigration(ElasticsearchClient client, String indexPrefix) throws IOException {
        String jobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, "jobrunr_jobs");
        if (M001_CreateJobsIndex.indexExists(client, jobIndexName)) {
            return;
        }
        M001_CreateJobsIndex.createIndex(client, M001_CreateJobsIndex.jobIndex(jobIndexName));
    }

    private static CreateIndexRequest jobIndex(String jobIndexName) {
        return new CreateIndexRequest.Builder().index(jobIndexName).mappings(m -> m.properties("jobAsJson", p -> p.text(t -> (ObjectBuilder)t.index(Boolean.valueOf(false)).store(Boolean.valueOf(true)))).properties("state", p -> p.keyword(k -> k)).properties("jobSignature", p -> p.keyword(k -> k)).properties("scheduledAt", p -> p.dateNanos(d -> d)).properties("updatedAt", p -> p.dateNanos(d -> d))).build();
    }
}

