/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;

public class M002_CreateRecurringJobsIndex
extends ElasticSearchMigration {
    @Override
    public void runMigration(ElasticsearchClient client, String indexPrefix) throws IOException {
        String recurringJobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, "jobrunr_recurring_jobs");
        if (M002_CreateRecurringJobsIndex.indexExists(client, recurringJobIndexName)) {
            return;
        }
        M002_CreateRecurringJobsIndex.createIndex(client, M002_CreateRecurringJobsIndex.recurringJobIndex(recurringJobIndexName));
    }

    private static CreateIndexRequest recurringJobIndex(String name) {
        return new CreateIndexRequest.Builder().index(name).mappings(m -> m.properties("jobAsJson", p -> p.text(t -> (ObjectBuilder)t.index(Boolean.valueOf(false)).store(Boolean.valueOf(true))))).build();
    }
}

