/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import java.io.IOException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;

public class M003_CreateBackgroundJobServersIndex
extends ElasticSearchMigration {
    @Override
    public void runMigration(ElasticsearchClient client, String indexPrefix) throws IOException {
        String backgroundJobServerIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, "jobrunr_background_job_servers");
        if (M003_CreateBackgroundJobServersIndex.indexExists(client, backgroundJobServerIndexName)) {
            return;
        }
        M003_CreateBackgroundJobServersIndex.createIndex(client, M003_CreateBackgroundJobServersIndex.index(backgroundJobServerIndexName));
    }

    private static CreateIndexRequest index(String name) {
        return new CreateIndexRequest.Builder().index(name).mappings(m -> m.properties("firstHeartbeat", p -> p.dateNanos(d -> d)).properties("lastHeartbeat", p -> p.dateNanos(d -> d))).build();
    }
}

