/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;

public class M005_CreateMetadataIndexAndDropJobStatsIndex
extends ElasticSearchMigration {
    private static final Class<Map> MAP_CLASS = Map.class;
    public static final String JOBRUNR_JOB_STATS = "jobrunr_job_stats";

    @Override
    public void runMigration(ElasticsearchClient client, String indexPrefix) throws IOException {
        String metadataIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, "jobrunr_metadata");
        M005_CreateMetadataIndexAndDropJobStatsIndex.createIndex(client, M005_CreateMetadataIndexAndDropJobStatsIndex.metadataIndex(metadataIndexName));
        this.migrateExistingAllTimeSucceededFromJobStatsToMetadataAndDropJobStats(client, metadataIndexName);
    }

    private void migrateExistingAllTimeSucceededFromJobStatsToMetadataAndDropJobStats(ElasticsearchClient client, String metadataIndexName) throws IOException {
        long totalSucceededAmount = 0L;
        if (M005_CreateMetadataIndexAndDropJobStatsIndex.indexExists(client, JOBRUNR_JOB_STATS)) {
            GetResponse getResponse = client.get(g -> g.index(JOBRUNR_JOB_STATS).id("job_stats"), MAP_CLASS);
            totalSucceededAmount = ((Integer)((Object)Optional.ofNullable((Map)getResponse.source()).orElse(Collections.EMPTY_MAP).getOrDefault(StateName.SUCCEEDED.toString(), 0L))).intValue();
            this.deleteIndex(client, JOBRUNR_JOB_STATS);
        }
        client.index(M005_CreateMetadataIndexAndDropJobStatsIndex.jobStats(totalSucceededAmount, metadataIndexName));
    }

    public static IndexRequest<Map<Object, Object>> jobStats(long totalSucceededAmount, String metadataIndexName) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", "succeeded-jobs-counter");
        map.put("owner", "cluster");
        map.put("value", totalSucceededAmount);
        Instant now = Instant.now();
        map.put("createdAt", now.toEpochMilli());
        map.put("updatedAt", now.toEpochMilli());
        return IndexRequest.of(i -> i.index(metadataIndexName).id("succeeded-jobs-counter-cluster").document((Object)map).refresh(Refresh.True));
    }

    private static CreateIndexRequest metadataIndex(String name) {
        return new CreateIndexRequest.Builder().index(name).mappings(m -> m.properties("name", p -> p.keyword(k -> k)).properties("owner", p -> p.keyword(k -> k)).properties("value", p -> p.text(t -> (ObjectBuilder)t.index(Boolean.valueOf(false)).store(Boolean.valueOf(true)))).properties("createdAt", p -> p.dateNanos(d -> d)).properties("updatedAt", p -> p.dateNanos(d -> d))).build();
    }
}

