/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.internal.UuidHelper;
import org.bson.types.Binary;
import org.jobrunr.JobRunrException;
import org.jobrunr.utils.CollectionUtils;

public class MongoUtils {
    private MongoUtils() {
    }

    public static UUID getIdAsUUID(Document document) {
        if (document.get((Object)"_id") instanceof UUID) {
            return (UUID)document.get((Object)"_id", UUID.class);
        }
        Binary idAsBinary = (Binary)document.get((Object)"_id", Binary.class);
        if (BsonBinarySubType.isUuid((byte)idAsBinary.getType())) {
            if (idAsBinary.getType() == BsonBinarySubType.UUID_STANDARD.getValue()) {
                return UuidHelper.decodeBinaryToUuid((byte[])MongoUtils.clone(idAsBinary.getData()), (byte)idAsBinary.getType(), (UuidRepresentation)UuidRepresentation.STANDARD);
            }
            if (idAsBinary.getType() == BsonBinarySubType.UUID_LEGACY.getValue()) {
                return UuidHelper.decodeBinaryToUuid((byte[])MongoUtils.clone(idAsBinary.getData()), (byte)idAsBinary.getType(), (UuidRepresentation)UuidRepresentation.JAVA_LEGACY);
            }
        }
        throw JobRunrException.shouldNotHappenException("Unknown id: " + document.get((Object)"_id").getClass());
    }

    public static Object toValueForBson(String fieldName, String value) {
        if (CollectionUtils.asSet("createdAt", "updatedAt", "scheduledAt").contains(fieldName)) {
            return MongoUtils.toMicroSeconds(Instant.parse(value));
        }
        return value;
    }

    public static byte[] clone(byte[] array) {
        byte[] result = new byte[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static long toMicroSeconds(Instant instant) {
        return ChronoUnit.MICROS.between(Instant.EPOCH, instant);
    }
}

