/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo.mapper;

import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;
import org.jobrunr.jobs.Job;
import org.jobrunr.storage.navigation.AmountRequest;
import org.jobrunr.storage.navigation.OrderTerm;

public class MongoDBAmountRequestMapper {
    public Bson mapToSort(AmountRequest amountRequest) {
        List<OrderTerm> orderTerms = amountRequest.getAllOrderTerms(Job.ALLOWED_SORT_COLUMNS.keySet());
        ArrayList<Bson> result = new ArrayList<Bson>();
        for (OrderTerm orderTerm : orderTerms) {
            result.add(OrderTerm.Order.ASC == orderTerm.getOrder() ? Sorts.ascending((String[])new String[]{orderTerm.getFieldName()}) : Sorts.descending((String[])new String[]{orderTerm.getFieldName()}));
        }
        if (result.size() == 1) {
            return (Bson)result.get(0);
        }
        return Sorts.orderBy(result);
    }
}

