/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo.migrations;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.mongo.MongoDBStorageProvider;
import org.jobrunr.storage.nosql.mongo.migrations.MongoMigration;

public class M005_CreateMetadataCollectionAndDropJobStats
extends MongoMigration {
    @Override
    public void runMigration(MongoDatabase jobrunrDatabase, String collectionPrefix) {
        String collectionName = StorageProviderUtils.elementPrefixer(collectionPrefix, "metadata");
        if (this.createCollection(jobrunrDatabase, collectionName)) {
            MongoCollection<Document> metadataCollection = this.createMetadataCollection(jobrunrDatabase, collectionName);
            this.migrateExistingAllTimeSucceededFromJobStatsToMetadataAndDropJobStats(jobrunrDatabase, metadataCollection);
        }
    }

    private MongoCollection<Document> createMetadataCollection(MongoDatabase jobrunrDatabase, String processedMetadataCollectionName) {
        MongoCollection metadataCollection = jobrunrDatabase.getCollection(processedMetadataCollectionName, Document.class);
        metadataCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"name"}), Indexes.ascending((String[])new String[]{"owner"})}));
        metadataCollection.insertOne((Object)this.initialAllTimeSucceededJobCounterDocument());
        return metadataCollection;
    }

    private void migrateExistingAllTimeSucceededFromJobStatsToMetadataAndDropJobStats(MongoDatabase jobrunrDatabase, MongoCollection<Document> metadataCollection) {
        if (!this.collectionExists(jobrunrDatabase, "job_stats")) {
            return;
        }
        MongoCollection jobStatsCollection = jobrunrDatabase.getCollection("job_stats", Document.class);
        Document jobStats = (Document)jobStatsCollection.find(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)"stats")).first();
        long existingAmount = jobStats != null ? (long)jobStats.getInteger((Object)StateName.SUCCEEDED.name()).intValue() : 0L;
        metadataCollection.updateOne(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)"succeeded-jobs-counter-cluster"), Updates.inc((String)"value", (Number)existingAmount), new UpdateOptions().upsert(true));
        jobStatsCollection.drop();
    }

    private Document initialAllTimeSucceededJobCounterDocument() {
        Document document = new Document();
        document.put("id", (Object)"succeeded-jobs-counter-cluster");
        document.put("name", (Object)"succeeded-jobs-counter");
        document.put("owner", (Object)"cluster");
        document.put("value", (Object)0L);
        return document;
    }
}

