/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.redis;

import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.common.NoSqlDatabaseCreator;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.jobrunr.storage.nosql.redis.migrations.JedisRedisMigration;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisRedisDBCreator
extends NoSqlDatabaseCreator<JedisRedisMigration> {
    private final JedisPool jedisPool;
    private final String keyPrefix;

    public JedisRedisDBCreator(NoSqlStorageProvider noSqlStorageProvider, JedisPool jedisPool, String keyPrefix) {
        super(noSqlStorageProvider);
        this.jedisPool = jedisPool;
        this.keyPrefix = keyPrefix;
    }

    @Override
    protected boolean isValidMigration(NoSqlMigration noSqlMigration) {
        return noSqlMigration.getClassName().contains("Jedis");
    }

    @Override
    protected boolean isNewMigration(NoSqlMigration noSqlMigration) {
        return true;
    }

    @Override
    protected void runMigration(JedisRedisMigration noSqlMigration) throws Exception {
        try (Jedis jedis = this.getJedis();){
            noSqlMigration.runMigration(jedis, this.keyPrefix);
        }
    }

    @Override
    protected boolean markMigrationAsDone(NoSqlMigration noSqlMigration) {
        return true;
    }

    protected Jedis getJedis() {
        return this.jedisPool.getResource();
    }
}

