/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.redis;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobListVersioner;
import org.jobrunr.jobs.JobVersioner;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.AbstractStorageProvider;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.storage.ServerTimedOutException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.navigation.AmountRequest;
import org.jobrunr.storage.navigation.OffsetBasedPageRequest;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.redis.JedisRedisDBCreator;
import org.jobrunr.storage.nosql.redis.JedisRedisPipelinedStream;
import org.jobrunr.storage.nosql.redis.RedisUtilities;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.annotations.Beta;
import org.jobrunr.utils.resilience.RateLimiter;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisException;

@Deprecated
@Beta
public class JedisRedisStorageProvider
extends AbstractStorageProvider
implements NoSqlStorageProvider {
    private final JedisPool jedisPool;
    private final String keyPrefix;
    private JobMapper jobMapper;

    public JedisRedisStorageProvider() {
        this(new JedisPool());
    }

    public JedisRedisStorageProvider(JedisPool jedisPool) {
        this(jedisPool, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public JedisRedisStorageProvider(JedisPool jedisPool, String keyPrefix) {
        this(jedisPool, keyPrefix, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public JedisRedisStorageProvider(JedisPool jedisPool, RateLimiter changeListenerNotificationRateLimit) {
        this(jedisPool, null, changeListenerNotificationRateLimit);
    }

    public JedisRedisStorageProvider(JedisPool jedisPool, String keyPrefix, RateLimiter changeListenerNotificationRateLimit) {
        super(changeListenerNotificationRateLimit);
        this.jedisPool = jedisPool;
        this.keyPrefix = StringUtils.isNullOrEmpty(keyPrefix) ? "" : keyPrefix;
        this.setUpStorageProvider(StorageProviderUtils.DatabaseOptions.CREATE);
    }

    @Override
    public void setJobMapper(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
        if (StorageProviderUtils.DatabaseOptions.CREATE != databaseOptions) {
            throw new IllegalArgumentException("JedisRedisStorageProvider only supports CREATE as databaseOptions.");
        }
        new JedisRedisDBCreator(this, this.jedisPool, this.keyPrefix).runMigrations();
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        try (Jedis jedis = this.getJedis();
             Transaction t = jedis.multi();){
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "id", serverStatus.getId().toString());
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "name", serverStatus.getName());
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "workerPoolSize", String.valueOf(serverStatus.getWorkerPoolSize()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "pollIntervalInSeconds", String.valueOf(serverStatus.getPollIntervalInSeconds()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "deleteSucceededJobsAfter", String.valueOf(serverStatus.getDeleteSucceededJobsAfter()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "permanentlyDeleteDeletedJobsAfter", String.valueOf(serverStatus.getPermanentlyDeleteDeletedJobsAfter()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "firstHeartbeat", String.valueOf(serverStatus.getFirstHeartbeat()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "lastHeartbeat", String.valueOf(serverStatus.getLastHeartbeat()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "running", String.valueOf(serverStatus.isRunning()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "systemTotalMemory", String.valueOf(serverStatus.getSystemTotalMemory()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "systemFreeMemory", String.valueOf(serverStatus.getSystemFreeMemory()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "systemCpuLoad", String.valueOf(serverStatus.getSystemCpuLoad()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "processMaxMemory", String.valueOf(serverStatus.getProcessMaxMemory()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "processFreeMemory", String.valueOf(serverStatus.getProcessFreeMemory()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "processAllocatedMemory", String.valueOf(serverStatus.getProcessAllocatedMemory()));
            t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "processCpuLoad", String.valueOf(serverStatus.getProcessCpuLoad()));
            t.zadd(RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), (double)RedisUtilities.toMicroSeconds(Instant.now()), serverStatus.getId().toString());
            t.zadd(RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), (double)RedisUtilities.toMicroSeconds(Instant.now()), serverStatus.getId().toString());
            t.exec();
        }
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        try (Jedis jedis = this.getJedis();){
            boolean bl;
            block13: {
                Map valueMap = jedis.hgetAll(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus));
                if (valueMap.isEmpty()) {
                    throw new ServerTimedOutException(serverStatus, new StorageException("BackgroundJobServer with id " + serverStatus.getId() + " was not found"));
                }
                jedis.watch(new String[]{RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus)});
                Transaction t = jedis.multi();
                try {
                    t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "lastHeartbeat", String.valueOf(serverStatus.getLastHeartbeat()));
                    t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "systemFreeMemory", String.valueOf(serverStatus.getSystemFreeMemory()));
                    t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "systemCpuLoad", String.valueOf(serverStatus.getSystemCpuLoad()));
                    t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "processFreeMemory", String.valueOf(serverStatus.getProcessFreeMemory()));
                    t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "processAllocatedMemory", String.valueOf(serverStatus.getProcessAllocatedMemory()));
                    t.hset(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "processCpuLoad", String.valueOf(serverStatus.getProcessCpuLoad()));
                    t.zadd(RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), (double)RedisUtilities.toMicroSeconds(Instant.now()), serverStatus.getId().toString());
                    Response isRunningResponse = t.hget(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus), "running");
                    t.exec();
                    bl = Boolean.parseBoolean((String)isRunningResponse.get());
                    if (t == null) break block13;
                }
                catch (Throwable throwable) {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                t.close();
            }
            return bl;
        }
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        try (Jedis jedis = this.getJedis();
             Transaction t = jedis.multi();){
            t.del(RedisUtilities.backgroundJobServerKey(this.keyPrefix, serverStatus.getId()));
            t.zrem(RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), new String[]{serverStatus.getId().toString()});
            t.zrem(RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), new String[]{serverStatus.getId().toString()});
            t.exec();
        }
    }

    @Override
    public List<BackgroundJobServerStatus> getBackgroundJobServers() {
        try (Jedis jedis = this.getJedis();){
            List<BackgroundJobServerStatus> list = new JedisRedisPipelinedStream<String>(jedis.zrange(RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), 0L, Integer.MAX_VALUE), jedis).mapUsingPipeline((p, id) -> p.hgetAll(RedisUtilities.backgroundJobServerKey(this.keyPrefix, id))).mapAfterSync(Response::get).map(fieldMap -> new BackgroundJobServerStatus(UUID.fromString((String)fieldMap.get("id")), (String)fieldMap.get("name"), Integer.parseInt((String)fieldMap.get("workerPoolSize")), Integer.parseInt((String)fieldMap.get("pollIntervalInSeconds")), Duration.parse((CharSequence)fieldMap.get("deleteSucceededJobsAfter")), Duration.parse((CharSequence)fieldMap.get("permanentlyDeleteDeletedJobsAfter")), Instant.parse((CharSequence)fieldMap.get("firstHeartbeat")), Instant.parse((CharSequence)fieldMap.get("lastHeartbeat")), Boolean.parseBoolean((String)fieldMap.get("running")), Long.parseLong((String)fieldMap.get("systemTotalMemory")), Long.parseLong((String)fieldMap.get("systemFreeMemory")), Double.parseDouble((String)fieldMap.get("systemCpuLoad")), Long.parseLong((String)fieldMap.get("processMaxMemory")), Long.parseLong((String)fieldMap.get("processFreeMemory")), Long.parseLong((String)fieldMap.get("processAllocatedMemory")), Double.parseDouble((String)fieldMap.get("processCpuLoad")))).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public UUID getLongestRunningBackgroundJobServerId() {
        try (Jedis jedis = this.getJedis();){
            UUID uUID = jedis.zrange(RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), 0L, 0L).stream().map(UUID::fromString).findFirst().orElseThrow(() -> new IllegalStateException("No servers available?!"));
            return uUID;
        }
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        try (Jedis jedis = this.getJedis();){
            List backgroundjobservers = jedis.zrangeByScore(RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), 0.0, (double)RedisUtilities.toMicroSeconds(heartbeatOlderThan));
            try (Transaction t = jedis.multi();){
                backgroundjobservers.forEach(backgroundJobServerId -> {
                    t.del(RedisUtilities.backgroundJobServerKey(this.keyPrefix, backgroundJobServerId));
                    t.zrem(RedisUtilities.backgroundJobServersCreatedKey(this.keyPrefix), new String[]{backgroundJobServerId});
                    t.zrem(RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), new String[]{backgroundJobServerId});
                });
                t.exec();
            }
            int n = backgroundjobservers.size();
            return n;
        }
    }

    @Override
    public void saveMetadata(JobRunrMetadata metadata) {
        try (Jedis jedis = this.getJedis();
             Transaction t = jedis.multi();){
            t.hset(RedisUtilities.metadataKey(this.keyPrefix, metadata), "id", metadata.getId());
            t.hset(RedisUtilities.metadataKey(this.keyPrefix, metadata), "name", metadata.getName());
            t.hset(RedisUtilities.metadataKey(this.keyPrefix, metadata), "owner", metadata.getOwner());
            t.hset(RedisUtilities.metadataKey(this.keyPrefix, metadata), "value", metadata.getValue());
            t.hset(RedisUtilities.metadataKey(this.keyPrefix, metadata), "createdAt", String.valueOf(metadata.getCreatedAt()));
            t.hset(RedisUtilities.metadataKey(this.keyPrefix, metadata), "updatedAt", String.valueOf(metadata.getUpdatedAt()));
            t.sadd(RedisUtilities.metadatasKey(this.keyPrefix), new String[]{RedisUtilities.metadataKey(this.keyPrefix, metadata)});
            t.exec();
            this.notifyMetadataChangeListeners();
        }
        catch (JedisException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<JobRunrMetadata> getMetadata(String name) {
        try (Jedis jedis = this.getJedis();){
            List<JobRunrMetadata> list = jedis.smembers(RedisUtilities.metadatasKey(this.keyPrefix)).stream().filter(metadataName -> metadataName.startsWith(RedisUtilities.metadataKey(this.keyPrefix, name + "-"))).map(arg_0 -> ((Jedis)jedis).hgetAll(arg_0)).map(fieldMap -> new JobRunrMetadata((String)fieldMap.get("name"), (String)fieldMap.get("owner"), (String)fieldMap.get("value"), Instant.parse((CharSequence)fieldMap.get("createdAt")), Instant.parse((CharSequence)fieldMap.get("updatedAt")))).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public JobRunrMetadata getMetadata(String name, String owner) {
        try (Jedis jedis = this.getJedis();){
            Map fieldMap = jedis.hgetAll(RedisUtilities.metadataKey(this.keyPrefix, JobRunrMetadata.toId(name, owner)));
            if (fieldMap.isEmpty()) {
                JobRunrMetadata jobRunrMetadata = null;
                return jobRunrMetadata;
            }
            JobRunrMetadata jobRunrMetadata = new JobRunrMetadata((String)fieldMap.get("name"), (String)fieldMap.get("owner"), (String)fieldMap.get("value"), Instant.parse((CharSequence)fieldMap.get("createdAt")), Instant.parse((CharSequence)fieldMap.get("updatedAt")));
            return jobRunrMetadata;
        }
    }

    @Override
    public void deleteMetadata(String name) {
        block14: {
            try (Jedis jedis = this.getJedis();){
                List<String> metadataToDelete = jedis.smembers(RedisUtilities.metadatasKey(this.keyPrefix)).stream().filter(metadataName -> metadataName.startsWith(RedisUtilities.metadataKey(this.keyPrefix, name + "-"))).collect(Collectors.toList());
                if (metadataToDelete.isEmpty()) break block14;
                try (Pipeline p = jedis.pipelined();){
                    metadataToDelete.forEach(metadataName -> {
                        p.hdel(metadataName, new String[0]);
                        p.srem(RedisUtilities.metadatasKey(this.keyPrefix), new String[]{metadataName});
                    });
                    p.sync();
                }
                this.notifyMetadataChangeListeners();
            }
            catch (JedisException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    public Job save(Job jobToSave) {
        try (Jedis jedis = this.getJedis();
             JobVersioner jobVersioner = new JobVersioner(jobToSave);){
            if (jobVersioner.isNewJob()) {
                this.insertJob(jobToSave, jedis);
            } else {
                this.updateJob(jobToSave, jedis);
            }
            jobVersioner.commitVersion();
            this.notifyJobStatsOnChangeListeners();
        }
        catch (JedisException e) {
            throw new StorageException(e);
        }
        return jobToSave;
    }

    @Override
    public int deletePermanently(UUID id) {
        Job job = this.getJobById(id);
        try (Jedis jedis = this.getJedis();){
            int n;
            block12: {
                Transaction transaction = jedis.multi();
                try {
                    transaction.del(RedisUtilities.jobKey(this.keyPrefix, job));
                    transaction.del(RedisUtilities.jobVersionKey(this.keyPrefix, job));
                    this.deleteJobMetadata(transaction, job);
                    List result = transaction.exec();
                    int amount = result == null || result.isEmpty() ? 0 : 1;
                    this.notifyJobStatsOnChangeListenersIf(amount > 0);
                    n = amount;
                    if (transaction == null) break block12;
                }
                catch (Throwable throwable) {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transaction.close();
            }
            return n;
        }
    }

    @Override
    public Job getJobById(UUID id) {
        try (Jedis jedis = this.getJedis();){
            String serializedJobAsString = jedis.get(RedisUtilities.jobKey(this.keyPrefix, id));
            if (serializedJobAsString == null) {
                throw new JobNotFoundException(id);
            }
            Job job = this.jobMapper.deserializeJob(serializedJobAsString);
            return job;
        }
    }

    @Override
    public long countJobs(StateName state) {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.zcount(RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), 0.0, 9.223372036854776E18);
            return l;
        }
    }

    @Override
    public List<Job> getJobList(StateName state, Instant updatedBefore, AmountRequest amountRequest) {
        try (Jedis jedis = this.getJedis();){
            List jobsByState;
            if ("updatedAt:ASC".equals(amountRequest.getOrder())) {
                jobsByState = jedis.zrangeByScore(RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), 0.0, (double)RedisUtilities.toMicroSeconds(updatedBefore), amountRequest instanceof OffsetBasedPageRequest ? (int)((OffsetBasedPageRequest)amountRequest).getOffset() : 0, amountRequest.getLimit());
            } else if ("updatedAt:DESC".equals(amountRequest.getOrder())) {
                jobsByState = jedis.zrevrangeByScore(RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), (double)RedisUtilities.toMicroSeconds(updatedBefore), 0.0, amountRequest instanceof OffsetBasedPageRequest ? (int)((OffsetBasedPageRequest)amountRequest).getOffset() : 0, amountRequest.getLimit());
            } else {
                throw new IllegalArgumentException("Unsupported sorting: " + amountRequest.getOrder());
            }
            List<Job> list = new JedisRedisPipelinedStream<String>(jobsByState, jedis).mapUsingPipeline((p, id) -> p.get(RedisUtilities.jobKey(this.keyPrefix, id))).mapAfterSync(Response::get).map(this.jobMapper::deserializeJob).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Job> getJobList(StateName state, AmountRequest amountRequest) {
        try (Jedis jedis = this.getJedis();){
            List jobsByState;
            int offset;
            int n = offset = amountRequest instanceof OffsetBasedPageRequest ? (int)((OffsetBasedPageRequest)amountRequest).getOffset() : 0;
            if ("updatedAt:ASC".equals(amountRequest.getOrder())) {
                jobsByState = jedis.zrange(RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), (long)offset, (long)(offset + amountRequest.getLimit() - 1));
            } else if ("updatedAt:DESC".equals(amountRequest.getOrder())) {
                jobsByState = jedis.zrevrange(RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), (long)offset, (long)(offset + amountRequest.getLimit() - 1));
            } else {
                throw new IllegalArgumentException("Unsupported sorting: " + amountRequest.getOrder());
            }
            List<Job> list = new JedisRedisPipelinedStream<String>(jobsByState, jedis).mapUsingPipeline((p, id) -> p.get(RedisUtilities.jobKey(this.keyPrefix, id))).mapAfterSync(Response::get).map(this.jobMapper::deserializeJob).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Job> getScheduledJobs(Instant scheduledBefore, AmountRequest amountRequest) {
        try (Jedis jedis = this.getJedis();){
            int offset = amountRequest instanceof OffsetBasedPageRequest ? (int)((OffsetBasedPageRequest)amountRequest).getOffset() : 0;
            List<Job> list = new JedisRedisPipelinedStream<String>(jedis.zrangeByScore(RedisUtilities.scheduledJobsKey(this.keyPrefix), 0.0, (double)RedisUtilities.toMicroSeconds(scheduledBefore), offset, amountRequest.getLimit()), jedis).mapUsingPipeline((p, id) -> p.get(RedisUtilities.jobKey(this.keyPrefix, id))).mapAfterSync(Response::get).map(this.jobMapper::deserializeJob).collect(Collectors.toList());
            return list;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Job> save(List<Job> jobs) {
        if (jobs.isEmpty()) {
            return jobs;
        }
        try (Jedis jedis = this.getJedis();){
            JobListVersioner jobListVersioner = new JobListVersioner(jobs);
            try {
                if (jobListVersioner.areNewJobs()) {
                    try (Transaction p = jedis.multi();){
                        jobs.forEach(jobToSave -> this.saveJob(p, (Job)jobToSave));
                        p.exec();
                    }
                } else {
                    List<Job> concurrentModifiedJobs = StorageProviderUtils.returnConcurrentModifiedJobs(jobs, job -> this.updateJob((Job)job, jedis));
                    if (!concurrentModifiedJobs.isEmpty()) {
                        jobListVersioner.rollbackVersions(concurrentModifiedJobs);
                        throw new ConcurrentJobModificationException(concurrentModifiedJobs);
                    }
                }
                jobListVersioner.commitVersions();
                this.notifyJobStatsOnChangeListenersIf(!jobs.isEmpty());
                List<Job> list = jobs;
                jobListVersioner.close();
                return list;
            }
            catch (Throwable throwable) {
                try {
                    jobListVersioner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JedisException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int deleteJobsPermanently(StateName state, Instant updatedBefore) {
        int amount;
        block14: {
            amount = 0;
            try (Jedis jedis = this.getJedis();){
                List zrangeToInspect = jedis.zrange(RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), 0L, 1000L);
                while (!zrangeToInspect.isEmpty()) {
                    for (String id : zrangeToInspect) {
                        Job job = this.getJobById(UUID.fromString(id));
                        if (job.getUpdatedAt().isAfter(updatedBefore)) {
                            break block14;
                        }
                        Transaction transaction = jedis.multi();
                        try {
                            transaction.del(RedisUtilities.jobKey(this.keyPrefix, job));
                            transaction.del(RedisUtilities.jobVersionKey(this.keyPrefix, job));
                            this.deleteJobMetadata(transaction, job);
                            List exec = transaction.exec();
                            if (exec == null || exec.isEmpty()) continue;
                            ++amount;
                        }
                        finally {
                            if (transaction == null) continue;
                            transaction.close();
                        }
                    }
                    zrangeToInspect = jedis.zrange(RedisUtilities.jobQueueForStateKey(this.keyPrefix, state), 0L, 1000L);
                }
            }
        }
        this.notifyJobStatsOnChangeListenersIf(amount > 0);
        return amount;
    }

    @Override
    public Set<String> getDistinctJobSignatures(StateName ... states) {
        try (Jedis jedis = this.getJedis();){
            Set<String> set;
            block12: {
                Pipeline p = jedis.pipelined();
                try {
                    List jobSignatures = Arrays.stream(states).map(stateName -> p.smembers(RedisUtilities.jobDetailsKey(this.keyPrefix, stateName))).collect(Collectors.toList());
                    p.sync();
                    set = jobSignatures.stream().flatMap(res -> ((Set)res.get()).stream()).collect(Collectors.toSet());
                    if (p == null) break block12;
                }
                catch (Throwable throwable) {
                    if (p != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                p.close();
            }
            return set;
        }
    }

    @Override
    public boolean recurringJobExists(String recurringJobId, StateName ... states) {
        try (Jedis jedis = this.getJedis();){
            boolean bl;
            block12: {
                Pipeline p = jedis.pipelined();
                try {
                    List existsJob = Arrays.stream(StateName.getStateNames(states)).map(stateName -> p.sismember(RedisUtilities.recurringJobKey(this.keyPrefix, stateName), recurringJobId)).collect(Collectors.toList());
                    p.sync();
                    bl = existsJob.stream().map(Response::get).filter(b -> b).findAny().orElse(false);
                    if (p == null) break block12;
                }
                catch (Throwable throwable) {
                    if (p != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                p.close();
            }
            return bl;
        }
    }

    @Override
    public RecurringJob saveRecurringJob(RecurringJob recurringJob) {
        try (Jedis jedis = this.getJedis();
             Transaction t = jedis.multi();){
            t.set(RedisUtilities.recurringJobKey(this.keyPrefix, recurringJob.getId()), this.jobMapper.serializeRecurringJob(recurringJob));
            t.sadd(RedisUtilities.recurringJobsKey(this.keyPrefix), new String[]{recurringJob.getId()});
            t.hset(RedisUtilities.recurringJobCreatedAtKey(this.keyPrefix), recurringJob.getId(), Long.toString(recurringJob.getCreatedAt().toEpochMilli()));
            t.exec();
        }
        return recurringJob;
    }

    @Override
    public boolean recurringJobsUpdated(Long recurringJobsUpdatedHash) {
        try (Jedis jedis = this.getJedis();){
            Long lastModifiedHash = jedis.hvals(RedisUtilities.recurringJobCreatedAtKey(this.keyPrefix)).stream().map(Long::valueOf).reduce(Long::sum).orElse(0L);
            boolean bl = !lastModifiedHash.equals(recurringJobsUpdatedHash);
            return bl;
        }
    }

    @Override
    public RecurringJobsResult getRecurringJobs() {
        try (Jedis jedis = this.getJedis();){
            List<RecurringJob> recurringJobs = jedis.smembers(RedisUtilities.recurringJobsKey(this.keyPrefix)).stream().map(id -> jedis.get(RedisUtilities.recurringJobKey(this.keyPrefix, id))).map(this.jobMapper::deserializeRecurringJob).collect(Collectors.toList());
            RecurringJobsResult recurringJobsResult = new RecurringJobsResult((Collection<RecurringJob>)recurringJobs);
            return recurringJobsResult;
        }
    }

    @Override
    public int deleteRecurringJob(String id) {
        try (Jedis jedis = this.getJedis();){
            int n;
            block12: {
                Transaction transaction = jedis.multi();
                try {
                    transaction.del(RedisUtilities.recurringJobKey(this.keyPrefix, id));
                    transaction.srem(RedisUtilities.recurringJobsKey(this.keyPrefix), new String[]{id});
                    transaction.hdel(RedisUtilities.recurringJobCreatedAtKey(this.keyPrefix), new String[]{id});
                    List exec = transaction.exec();
                    int n2 = n = exec != null && !exec.isEmpty() ? 1 : 0;
                    if (transaction == null) break block12;
                }
                catch (Throwable throwable) {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transaction.close();
            }
            return n;
        }
    }

    @Override
    public JobStats getJobStats() {
        Instant instant = Instant.now();
        try (Jedis jedis = this.getJedis();){
            JobStats jobStats;
            block12: {
                Pipeline p = jedis.pipelined();
                try {
                    Response totalAmountSucceeded = p.hget(RedisUtilities.metadataKey(this.keyPrefix, "succeeded-jobs-counter-cluster"), "value");
                    Response scheduledResponse = p.zcount(RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.SCHEDULED), 0.0, 9.223372036854776E18);
                    Response enqueuedResponse = p.zcount(RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.ENQUEUED), 0.0, 9.223372036854776E18);
                    Response processingResponse = p.zcount(RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.PROCESSING), 0.0, 9.223372036854776E18);
                    Response succeededResponse = p.zcount(RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.SUCCEEDED), 0.0, 9.223372036854776E18);
                    Response failedResponse = p.zcount(RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.FAILED), 0.0, 9.223372036854776E18);
                    Response deletedResponse = p.zcount(RedisUtilities.jobQueueForStateKey(this.keyPrefix, StateName.DELETED), 0.0, 9.223372036854776E18);
                    Response recurringJobsResponse = p.scard(RedisUtilities.recurringJobsKey(this.keyPrefix));
                    Response backgroundJobServerResponse = p.zcount(RedisUtilities.backgroundJobServersUpdatedKey(this.keyPrefix), 0.0, 9.223372036854776E18);
                    p.sync();
                    Long scheduledCount = (Long)scheduledResponse.get();
                    Long enqueuedCount = (Long)enqueuedResponse.get();
                    Long processingCount = (Long)processingResponse.get();
                    Long succeededCount = (Long)succeededResponse.get();
                    Long allTimeSucceededCount = Long.parseLong(totalAmountSucceeded.get() != null ? (String)totalAmountSucceeded.get() : "0");
                    Long failedCount = (Long)failedResponse.get();
                    Long deletedCount = (Long)deletedResponse.get();
                    Long total = scheduledCount + enqueuedCount + processingCount + (Long)succeededResponse.get() + failedCount;
                    Long recurringJobsCount = (Long)recurringJobsResponse.get();
                    Long backgroundJobServerCount = (Long)backgroundJobServerResponse.get();
                    jobStats = new JobStats(instant, total, scheduledCount, enqueuedCount, processingCount, failedCount, succeededCount, allTimeSucceededCount, deletedCount, recurringJobsCount.intValue(), backgroundJobServerCount.intValue());
                    if (p == null) break block12;
                }
                catch (Throwable throwable) {
                    if (p != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                p.close();
            }
            return jobStats;
        }
    }

    @Override
    public void publishTotalAmountOfSucceededJobs(int amount) {
        try (Jedis jedis = this.getJedis();){
            jedis.hincrBy(RedisUtilities.metadataKey(this.keyPrefix, "succeeded-jobs-counter-cluster"), "value", (long)amount);
        }
    }

    protected Jedis getJedis() {
        return this.jedisPool.getResource();
    }

    private void insertJob(Job jobToSave, Jedis jedis) {
        if (jedis.exists(RedisUtilities.jobKey(this.keyPrefix, jobToSave))) {
            throw new ConcurrentJobModificationException(jobToSave);
        }
        try (Transaction transaction = jedis.multi();){
            this.saveJob(transaction, jobToSave);
            List result = transaction.exec();
            if (result == null || result.isEmpty()) {
                throw new StorageException("Unable to save job " + jobToSave.getId() + " with version " + jobToSave.getVersion());
            }
        }
    }

    private void updateJob(Job jobToSave, Jedis jedis) {
        jedis.watch(new String[]{RedisUtilities.jobVersionKey(this.keyPrefix, jobToSave)});
        String versionAsString = jedis.get(RedisUtilities.jobVersionKey(this.keyPrefix, jobToSave));
        if (versionAsString == null || Integer.parseInt(versionAsString) != jobToSave.getVersion() - 1) {
            throw new ConcurrentJobModificationException(jobToSave);
        }
        try (Transaction transaction = jedis.multi();){
            this.saveJob(transaction, jobToSave);
            List result = transaction.exec();
            jedis.unwatch();
            if (result == null || result.isEmpty()) {
                throw new ConcurrentJobModificationException(jobToSave);
            }
        }
    }

    private void saveJob(Transaction transaction, Job jobToSave) {
        this.deleteJobMetadataForUpdate(transaction, jobToSave);
        transaction.set(RedisUtilities.jobVersionKey(this.keyPrefix, jobToSave), String.valueOf(jobToSave.getVersion()));
        transaction.set(RedisUtilities.jobKey(this.keyPrefix, jobToSave), this.jobMapper.serializeJob(jobToSave));
        transaction.zadd(RedisUtilities.jobQueueForStateKey(this.keyPrefix, jobToSave.getState()), (double)RedisUtilities.toMicroSeconds(jobToSave.getUpdatedAt()), jobToSave.getId().toString());
        transaction.sadd(RedisUtilities.jobDetailsKey(this.keyPrefix, jobToSave.getState()), new String[]{JobUtils.getJobSignature(jobToSave.getJobDetails())});
        if (StateName.SCHEDULED.equals((Object)jobToSave.getState())) {
            transaction.zadd(RedisUtilities.scheduledJobsKey(this.keyPrefix), (double)RedisUtilities.toMicroSeconds(((ScheduledState)jobToSave.getJobState()).getScheduledAt()), jobToSave.getId().toString());
        }
        jobToSave.getRecurringJobId().ifPresent(recurringJobId -> transaction.sadd(RedisUtilities.recurringJobKey(this.keyPrefix, jobToSave.getState()), new String[]{recurringJobId}));
    }

    private void deleteJobMetadataForUpdate(Transaction transaction, Job job) {
        String id = job.getId().toString();
        transaction.zrem(RedisUtilities.scheduledJobsKey(this.keyPrefix), new String[]{id});
        Stream.of(StateName.values()).forEach(stateName -> transaction.zrem(RedisUtilities.jobQueueForStateKey(this.keyPrefix, stateName), new String[]{id}));
        Stream.of(StateName.values()).filter(stateName -> !StateName.SCHEDULED.equals(stateName)).forEach(stateName -> transaction.srem(RedisUtilities.jobDetailsKey(this.keyPrefix, stateName), new String[]{JobUtils.getJobSignature(job.getJobDetails())}));
        if (job.hasState(StateName.ENQUEUED) && job.getJobStates().size() >= 2 && job.getJobState(-2) instanceof ScheduledState || job.hasState(StateName.DELETED) && job.getJobStates().size() >= 2 && job.getJobState(-2) instanceof ScheduledState) {
            transaction.srem(RedisUtilities.jobDetailsKey(this.keyPrefix, StateName.SCHEDULED), new String[]{JobUtils.getJobSignature(job.getJobDetails())});
        }
        job.getRecurringJobId().ifPresent(recurringJobId -> Stream.of(StateName.values()).forEach(stateName -> transaction.srem(RedisUtilities.recurringJobKey(this.keyPrefix, stateName), new String[]{recurringJobId})));
    }

    private void deleteJobMetadata(Transaction transaction, Job job) {
        String id = job.getId().toString();
        transaction.zrem(RedisUtilities.scheduledJobsKey(this.keyPrefix), new String[]{id});
        Stream.of(StateName.values()).forEach(stateName -> transaction.zrem(RedisUtilities.jobQueueForStateKey(this.keyPrefix, stateName), new String[]{id}));
        Stream.of(StateName.values()).forEach(stateName -> transaction.srem(RedisUtilities.jobDetailsKey(this.keyPrefix, stateName), new String[]{JobUtils.getJobSignature(job.getJobDetails())}));
        job.getRecurringJobId().ifPresent(recurringJobId -> Stream.of(StateName.values()).forEach(stateName -> transaction.srem(RedisUtilities.recurringJobKey(this.keyPrefix, stateName), new String[]{recurringJobId})));
    }
}

