/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.redis;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.utils.StringUtils;

public class RedisUtilities {
    private RedisUtilities() {
    }

    @Deprecated
    public static String jobCounterKey(StateName stateName) {
        return "counter:jobs:" + (Object)((Object)stateName);
    }

    public static String backgroundJobServersCreatedKey(String keyPrefix) {
        return RedisUtilities.toRedisKey(keyPrefix, "backgroundjobservers", "created");
    }

    public static String backgroundJobServersUpdatedKey(String keyPrefix) {
        return RedisUtilities.toRedisKey(keyPrefix, "backgroundjobservers", "updated");
    }

    public static String backgroundJobServerKey(String keyPrefix, BackgroundJobServerStatus serverStatus) {
        return RedisUtilities.backgroundJobServerKey(keyPrefix, serverStatus.getId());
    }

    public static String backgroundJobServerKey(String keyPrefix, UUID serverId) {
        return RedisUtilities.backgroundJobServerKey(keyPrefix, serverId.toString());
    }

    public static String backgroundJobServerKey(String keyPrefix, String serverId) {
        return RedisUtilities.toRedisKey(keyPrefix, "backgroundjobserver", serverId);
    }

    public static String metadatasKey(String keyPrefix) {
        return RedisUtilities.toRedisKey(keyPrefix, "set", "metadata");
    }

    public static String metadataKey(String keyPrefix, JobRunrMetadata metadata) {
        return RedisUtilities.toRedisKey(keyPrefix, "metadata", metadata.getId());
    }

    public static String metadataKey(String keyPrefix, String metadataId) {
        return RedisUtilities.toRedisKey(keyPrefix, "metadata", metadataId);
    }

    public static String jobQueueForStateKey(String keyPrefix, StateName stateName) {
        return RedisUtilities.toRedisKey(keyPrefix, "queue", "jobs", stateName.toString());
    }

    public static String recurringJobsKey(String keyPrefix) {
        return RedisUtilities.toRedisKey(keyPrefix, "recurringjobs");
    }

    public static String recurringJobKey(String keyPrefix, String id) {
        return RedisUtilities.toRedisKey(keyPrefix, "recurringjob", id);
    }

    public static String recurringJobCreatedAtKey(String keyPrefix) {
        return RedisUtilities.toRedisKey(keyPrefix, "recurringjob", "createdAt");
    }

    public static String scheduledJobsKey(String keyPrefix) {
        return RedisUtilities.toRedisKey(keyPrefix, "queue", "scheduledjobs");
    }

    public static String jobKey(String keyPrefix, Job job) {
        return RedisUtilities.jobKey(keyPrefix, job.getId());
    }

    public static String jobKey(String keyPrefix, UUID id) {
        return RedisUtilities.jobKey(keyPrefix, id.toString());
    }

    public static String jobKey(String keyPrefix, String id) {
        return RedisUtilities.toRedisKey(keyPrefix, "job", id);
    }

    public static String jobDetailsKey(String keyPrefix, StateName stateName) {
        return RedisUtilities.toRedisKey(keyPrefix, "job", "jobdetails", stateName.toString());
    }

    public static String recurringJobKey(String keyPrefix, StateName stateName) {
        return RedisUtilities.toRedisKey(keyPrefix, "job", "recurring-job-id", stateName.toString());
    }

    public static String jobVersionKey(String keyPrefix, Job job) {
        return RedisUtilities.jobVersionKey(keyPrefix, job.getId());
    }

    public static String jobVersionKey(String keyPrefix, UUID id) {
        return RedisUtilities.toRedisKey(RedisUtilities.jobKey(keyPrefix, id), "version");
    }

    private static String toRedisKey(String ... keyParts) {
        return Stream.of(keyParts).filter(StringUtils::isNotNullOrEmpty).collect(Collectors.joining(":"));
    }

    public static long toMicroSeconds(Instant instant) {
        return ChronoUnit.MICROS.between(Instant.EPOCH, instant);
    }
}

