/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.redis.migrations;

import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.io.IOException;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.nosql.redis.RedisUtilities;
import org.jobrunr.storage.nosql.redis.migrations.LettuceRedisMigration;
import org.jobrunr.utils.StringUtils;

public class M001_LettuceRemoveJobStatsAndUseMetadata
extends LettuceRedisMigration {
    @Override
    public void runMigration(StatefulRedisConnection<String, String> connection, String keyPrefix) throws IOException {
        String succeededCounterResponse;
        RedisCommands commands = connection.sync();
        if (commands.hget((Object)RedisUtilities.metadataKey(keyPrefix, "succeeded-jobs-counter-cluster"), (Object)"value") != null) {
            return;
        }
        String string = succeededCounterResponse = commands.get((Object)RedisUtilities.jobCounterKey(StateName.SUCCEEDED)) != null ? (String)commands.get((Object)RedisUtilities.jobCounterKey(StateName.SUCCEEDED)) : null;
        if (StringUtils.isNotNullOrEmpty(succeededCounterResponse)) {
            commands.hincrby((Object)RedisUtilities.metadataKey(keyPrefix, "succeeded-jobs-counter-cluster"), (Object)"value", Long.parseLong(succeededCounterResponse));
            commands.del((Object[])new String[]{RedisUtilities.jobCounterKey(StateName.SUCCEEDED)});
        } else {
            commands.hset((Object)RedisUtilities.metadataKey(keyPrefix, "succeeded-jobs-counter-cluster"), (Object)"value", (Object)"0");
        }
    }
}

