/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.sql.Connection;
import java.time.Instant;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.sql.common.db.Dialect;
import org.jobrunr.storage.sql.common.db.Sql;
import org.jobrunr.storage.sql.common.db.SqlResultSet;

public class JobStatsView
extends Sql<JobStats> {
    public JobStatsView(Connection connection, Dialect dialect, String tablePrefix) {
        this.using(connection, dialect, tablePrefix, "jobrunr_jobs_stats");
    }

    public JobStats getJobStats() {
        Instant instant = Instant.now();
        return this.select("* from jobrunr_jobs_stats").map(resultSet -> this.toJobStats((SqlResultSet)resultSet, instant)).findFirst().orElse(JobStats.empty());
    }

    private JobStats toJobStats(SqlResultSet resultSet, Instant instant) {
        return new JobStats(instant, resultSet.asLong("total"), resultSet.asLong("scheduled"), resultSet.asLong("enqueued"), resultSet.asLong("processing"), resultSet.asLong("failed"), resultSet.asLong("succeeded"), resultSet.asLong("allTimeSucceeded"), resultSet.asLong("deleted"), resultSet.asInt("nbrOfRecurringJobs"), resultSet.asInt("nbrOfBackgroundJobServers"));
    }
}

