/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.jobs.AbstractJob;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobListVersioner;
import org.jobrunr.jobs.JobVersioner;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.navigation.AmountRequest;
import org.jobrunr.storage.sql.common.db.ConcurrentSqlModificationException;
import org.jobrunr.storage.sql.common.db.Dialect;
import org.jobrunr.storage.sql.common.db.Sql;
import org.jobrunr.storage.sql.common.db.SqlResultSet;
import org.jobrunr.storage.sql.common.mapper.SqlJobPageRequestMapper;
import org.jobrunr.utils.CollectionUtils;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobTable
extends Sql<Job> {
    private final JobMapper jobMapper;
    private final SqlJobPageRequestMapper pageRequestMapper;

    public JobTable(Connection connection, Dialect dialect, String tablePrefix, JobMapper jobMapper) {
        this.pageRequestMapper = new SqlJobPageRequestMapper(this, dialect);
        this.jobMapper = jobMapper;
        this.using(connection, dialect, tablePrefix, "jobrunr_jobs").withVersion(AbstractJob::getVersion).with("jobAsJson", jobMapper::serializeJob).with("jobSignature", JobUtils::getJobSignature).with("scheduledAt", (T job) -> job.hasState(StateName.SCHEDULED) ? ((ScheduledState)job.getJobState()).getScheduledAt() : null).with("recurringJobId", (T job) -> job.getRecurringJobId().orElse(null));
    }

    public JobTable withId(UUID id) {
        this.with("id", id);
        return this;
    }

    public JobTable withState(StateName state) {
        this.with("state", state);
        return this;
    }

    public JobTable withScheduledAt(Instant scheduledBefore) {
        this.with("scheduledAt", scheduledBefore);
        return this;
    }

    public JobTable withUpdatedBefore(Instant updatedBefore) {
        this.with("updatedBefore", updatedBefore);
        return this;
    }

    public JobTable with(String columnName, String sqlName, String value) {
        if (CollectionUtils.asSet("createdAt", "updatedAt", "scheduledAt").contains(columnName)) {
            this.with(sqlName, Instant.parse(value));
        } else {
            this.with(sqlName, value);
        }
        return this;
    }

    public Job save(Job jobToSave) throws SQLException {
        try (JobVersioner jobVersioner = new JobVersioner(jobToSave);){
            if (jobVersioner.isNewJob()) {
                this.insertOneJob(jobToSave);
            } else {
                this.updateOneJob(jobToSave);
            }
            jobVersioner.commitVersion();
        }
        catch (ConcurrentSqlModificationException e) {
            throw new ConcurrentJobModificationException(jobToSave, (Exception)e);
        }
        return jobToSave;
    }

    public List<Job> save(List<Job> jobs) throws SQLException {
        if (jobs.isEmpty()) {
            return jobs;
        }
        JobListVersioner jobListVersioner = new JobListVersioner(jobs);
        try {
            if (jobListVersioner.areNewJobs()) {
                this.insertAllJobs(jobs);
            } else {
                this.updateAllJobs(jobs);
            }
            jobListVersioner.commitVersions();
            List<Job> list = jobs;
            return list;
        }
        catch (ConcurrentSqlModificationException e) {
            List concurrentUpdatedJobs = (List)ReflectionUtils.cast(e.getFailedItems());
            jobListVersioner.rollbackVersions(concurrentUpdatedJobs);
            throw new ConcurrentJobModificationException(concurrentUpdatedJobs, (Exception)e);
        }
        finally {
            try {
                jobListVersioner.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public Optional<Job> selectJobById(UUID id) {
        return this.withId(id).selectJobs("jobAsJson from jobrunr_jobs where id = :id").findFirst();
    }

    public long countJobs(StateName state) throws SQLException {
        return this.withState(state).selectCount("from jobrunr_jobs where state = :state");
    }

    public List<Job> selectJobsByState(StateName state, AmountRequest amountRequest) {
        return this.withState(state).selectJobs("jobAsJson from jobrunr_jobs where state = :state", this.pageRequestMapper.map(amountRequest)).collect(Collectors.toList());
    }

    public List<Job> selectJobsToProcess(AmountRequest amountRequest) {
        return this.withState(StateName.ENQUEUED).selectJobs("jobAsJson from jobrunr_jobs where state = :state", this.pageRequestMapper.map(amountRequest) + this.dialect.selectForUpdateSkipLocked()).collect(Collectors.toList());
    }

    public List<Job> selectJobsByState(StateName state, Instant updatedBefore, AmountRequest amountRequest) {
        return this.withState(state).withUpdatedBefore(updatedBefore).selectJobs("jobAsJson from jobrunr_jobs where state = :state AND updatedAt <= :updatedBefore", this.pageRequestMapper.map(amountRequest)).collect(Collectors.toList());
    }

    public List<Job> selectJobsScheduledBefore(Instant scheduledBefore, AmountRequest amountRequest) {
        return this.withScheduledAt(scheduledBefore).selectJobs("jobAsJson from jobrunr_jobs where state = 'SCHEDULED' and scheduledAt <= :scheduledAt", this.pageRequestMapper.map(amountRequest)).collect(Collectors.toList());
    }

    public Set<String> getDistinctJobSignatures(StateName[] states) {
        return this.select("distinct jobSignature from jobrunr_jobs where state in (" + Arrays.stream(states).map(stateName -> "'" + stateName.name() + "'").collect(Collectors.joining(",")) + ")").map(resultSet -> resultSet.asString("jobSignature")).collect(Collectors.toSet());
    }

    public boolean recurringJobExists(String recurringJobId, StateName ... states) throws SQLException {
        if (states.length < 1) {
            return this.with("recurringJobId", recurringJobId).selectExists("from jobrunr_jobs where recurringJobId = :recurringJobId");
        }
        return this.with("recurringJobId", recurringJobId).selectExists("from jobrunr_jobs where state in (" + Arrays.stream(states).map(stateName -> "'" + stateName.name() + "'").collect(Collectors.joining(",")) + ") AND recurringJobId = :recurringJobId");
    }

    public int deletePermanently(UUID ... ids) throws SQLException {
        return this.delete("from jobrunr_jobs where id in (" + Arrays.stream(ids).map(uuid -> "'" + uuid.toString() + "'").collect(Collectors.joining(",")) + ")");
    }

    public int deleteJobsByStateAndUpdatedBefore(StateName state, Instant updatedBefore) throws SQLException {
        return this.withState(state).withUpdatedBefore(updatedBefore).delete("from jobrunr_jobs where state = :state AND updatedAt <= :updatedBefore");
    }

    void insertOneJob(Job jobToSave) throws SQLException {
        this.insert(jobToSave, "into jobrunr_jobs values (:id, :version, :jobAsJson, :jobSignature, :state, :createdAt, :updatedAt, :scheduledAt, :recurringJobId)");
    }

    void updateOneJob(Job jobToSave) throws SQLException {
        this.update(jobToSave, "jobrunr_jobs SET version = :version, jobAsJson = :jobAsJson, state = :state, updatedAt =:updatedAt, scheduledAt = :scheduledAt WHERE id = :id and version = :previousVersion");
    }

    void insertAllJobs(List<Job> jobs) throws SQLException {
        this.insertAll(jobs, "into jobrunr_jobs values (:id, :version, :jobAsJson, :jobSignature, :state, :createdAt, :updatedAt, :scheduledAt, :recurringJobId)");
    }

    void updateAllJobs(List<Job> jobs) throws SQLException {
        this.updateAll(jobs, "jobrunr_jobs SET version = :version, jobAsJson = :jobAsJson, state = :state, updatedAt =:updatedAt, scheduledAt = :scheduledAt WHERE id = :id and version = :previousVersion");
    }

    private Stream<Job> selectJobs(String statement) {
        return this.selectJobs(statement, "");
    }

    private Stream<Job> selectJobs(String statement, String filter) {
        Stream<SqlResultSet> select = super.select(statement, filter);
        return select.map(this::toJob);
    }

    private Job toJob(SqlResultSet resultSet) {
        return this.jobMapper.deserializeJob(resultSet.asString("jobAsJson"));
    }
}

