/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.Paging;
import org.jobrunr.storage.navigation.AmountRequest;
import org.jobrunr.storage.sql.common.db.Dialect;
import org.jobrunr.storage.sql.common.db.Sql;
import org.jobrunr.storage.sql.common.db.SqlResultSet;
import org.jobrunr.storage.sql.common.mapper.SqlAmountRequestMapper;
import org.jobrunr.utils.CollectionUtils;

public class MetadataTable
extends Sql<JobRunrMetadata> {
    private final SqlAmountRequestMapper amountRequestMapper;

    public MetadataTable(Connection connection, Dialect dialect, String tablePrefix) {
        this.amountRequestMapper = new SqlAmountRequestMapper(dialect, CollectionUtils.asSet("name", "createdAt", "updatedAt"));
        this.using(connection, dialect, tablePrefix, "jobrunr_metadata").with("id", JobRunrMetadata::getId).with("name", JobRunrMetadata::getName).with("owner", JobRunrMetadata::getOwner).with("value", JobRunrMetadata::getValue).with("createdAt", JobRunrMetadata::getCreatedAt).with("updatedAt", (T metadata) -> Instant.now());
    }

    public MetadataTable withId(String id) {
        this.with("id", id);
        return this;
    }

    public MetadataTable withName(String name) {
        this.with("name", name);
        return this;
    }

    public JobRunrMetadata save(JobRunrMetadata metadata) throws SQLException {
        this.withId(metadata.getId());
        if (this.selectExists("from jobrunr_metadata where id = :id")) {
            this.update(metadata, "jobrunr_metadata SET value = :value, updatedAt = :updatedAt WHERE id = :id");
        } else {
            this.insert(metadata, "into jobrunr_metadata values(:id, :name, :owner, :value, :createdAt, :updatedAt)");
        }
        return metadata;
    }

    public JobRunrMetadata get(String name, String owner) {
        return this.withName(name).with("owner", owner).select("* from jobrunr_metadata where name = :name and owner = :owner").map(this::toJobRunrMetadata).findFirst().orElse(null);
    }

    public List<JobRunrMetadata> getAll(String name) {
        return this.withName(name).select("* from jobrunr_metadata where name = :name", Paging.AmountBasedList.ascOnUpdatedAt(1000)).map(this::toJobRunrMetadata).collect(Collectors.toList());
    }

    public void incrementCounter(String id, int amount) throws SQLException {
        this.with("id", id).with("amount", amount).update("jobrunr_metadata set value = cast(round((cast(cast( value as char(10) ) as decimal(10, 0)) + :amount), 0) as char(10)) where id = :id");
    }

    public int deleteByName(String name) throws SQLException {
        return this.with("name", name).delete("from jobrunr_metadata where name = :name");
    }

    private JobRunrMetadata toJobRunrMetadata(SqlResultSet resultSet) {
        return new JobRunrMetadata(resultSet.asString("name"), resultSet.asString("owner"), resultSet.asString("value"), resultSet.asInstant("createdAt"), resultSet.asInstant("updatedAt"));
    }

    private Stream<SqlResultSet> select(String statement, AmountRequest amountRequest) {
        return super.select(statement, this.amountRequestMapper.mapToSqlQuery(amountRequest, this));
    }
}

