/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jobrunr.JobRunrException;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.SqlStorageProvider;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class SqlStorageProviderFactory {
    protected SqlStorageProviderFactory() {
    }

    public static StorageProvider using(DataSource dataSource) {
        return SqlStorageProviderFactory.using(dataSource, null, StorageProviderUtils.DatabaseOptions.CREATE);
    }

    public static StorageProvider using(DataSource dataSource, String tablePrefix) {
        return SqlStorageProviderFactory.using(dataSource, tablePrefix, StorageProviderUtils.DatabaseOptions.CREATE);
    }

    public static StorageProvider using(DataSource dataSource, String tablePrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        SqlStorageProviderFactory sqlStorageProviderFactory = new SqlStorageProviderFactory();
        return sqlStorageProviderFactory.getStorageProviderUsingDataSource(dataSource, tablePrefix, databaseOptions);
    }

    StorageProvider getStorageProviderUsingDataSource(DataSource dataSource, String tablePrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        StorageProvider storageProvider;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                String jdbcUrl = connection.getMetaData().getURL();
                storageProvider = this.getStorageProviderByJdbcUrl(jdbcUrl, dataSource, tablePrefix, databaseOptions);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw JobRunrException.shouldNotHappenException(e);
                }
            }
            connection.close();
        }
        return storageProvider;
    }

    StorageProvider getStorageProviderByJdbcUrl(String jdbcUrl, DataSource dataSource, String tablePrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        Class<SqlStorageProvider> storageProviderClassByJdbcUrl = this.getStorageProviderClassByJdbcUrl(jdbcUrl);
        return this.getStorageProvider(storageProviderClassByJdbcUrl, dataSource, tablePrefix, databaseOptions);
    }

    Class<SqlStorageProvider> getStorageProviderClassByJdbcUrl(String jdbcUrl) {
        if (jdbcUrl.startsWith("jdbc:sqlite")) {
            return this.getStorageProviderClass(SqlStorageProvider.class.getPackage().getName() + ".sqlite.SqLiteStorageProvider");
        }
        if (jdbcUrl.startsWith("jdbc:h2")) {
            return this.getStorageProviderClass(SqlStorageProvider.class.getPackage().getName() + ".h2.H2StorageProvider");
        }
        if (jdbcUrl.startsWith("jdbc:postgres")) {
            return this.getStorageProviderClass(SqlStorageProvider.class.getPackage().getName() + ".postgres.PostgresStorageProvider");
        }
        if (jdbcUrl.startsWith("jdbc:mysql")) {
            return this.getStorageProviderClass(SqlStorageProvider.class.getPackage().getName() + ".mysql.MySqlStorageProvider");
        }
        if (jdbcUrl.startsWith("jdbc:mariadb")) {
            return this.getStorageProviderClass(SqlStorageProvider.class.getPackage().getName() + ".mariadb.MariaDbStorageProvider");
        }
        if (jdbcUrl.startsWith("jdbc:oracle")) {
            return this.getStorageProviderClass(SqlStorageProvider.class.getPackage().getName() + ".oracle.OracleStorageProvider");
        }
        if (jdbcUrl.startsWith("jdbc:sqlserver")) {
            return this.getStorageProviderClass(SqlStorageProvider.class.getPackage().getName() + ".sqlserver.SQLServerStorageProvider");
        }
        if (jdbcUrl.startsWith("jdbc:db2")) {
            return this.getStorageProviderClass(SqlStorageProvider.class.getPackage().getName() + ".db2.DB2StorageProvider");
        }
        throw this.unsupportedDataSourceException(jdbcUrl);
    }

    StorageProvider getStorageProvider(Class<SqlStorageProvider> jobStorageProviderClass, DataSource dataSource, String tablePrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        try {
            Constructor<SqlStorageProvider> declaredConstructor = jobStorageProviderClass.getDeclaredConstructor(DataSource.class, String.class, StorageProviderUtils.DatabaseOptions.class);
            return declaredConstructor.newInstance(new Object[]{dataSource, tablePrefix, databaseOptions});
        }
        catch (ReflectiveOperationException e) {
            throw JobRunrException.shouldNotHappenException(e);
        }
    }

    Class<SqlStorageProvider> getStorageProviderClass(String className) {
        try {
            return (Class)ReflectionUtils.cast(Class.forName(className));
        }
        catch (ReflectiveOperationException e) {
            throw JobRunrException.shouldNotHappenException(e);
        }
    }

    JobRunrException unsupportedDataSourceException(String jdbcUrl) {
        return new JobRunrException("Are you running an unsupported DataSource or Database? Please check the documentation. If you think this is wrong, please open an issue using the following url: https://github.com/jobrunr/jobrunr/issues/new?template=bug_report.md&title=%5BBUG%5D5%20-%20missing%20DataSource%20" + jdbcUrl);
    }
}

