/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.sql.common.db.SqlUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class ConcurrentSqlModificationException
extends StorageException {
    private final List<?> items;
    private final int[] insertOrUpdateResult;

    public static ConcurrentSqlModificationException concurrentDatabaseModificationException(Object item, int insertOrUpdateResult) {
        return ConcurrentSqlModificationException.concurrentDatabaseModificationException(Collections.singletonList(item), new int[]{insertOrUpdateResult});
    }

    public static ConcurrentSqlModificationException concurrentDatabaseModificationException(List<?> items, int[] insertOrUpdateResult) {
        return new ConcurrentSqlModificationException("Could not insert or update all objects - not all updates succeeded: " + Arrays.toString(insertOrUpdateResult), items, insertOrUpdateResult);
    }

    private ConcurrentSqlModificationException(String reason, List<?> items, int[] insertOrUpdateResult) {
        super(reason);
        this.items = items;
        this.insertOrUpdateResult = insertOrUpdateResult;
    }

    public List<Object> getFailedItems() {
        return (List)ReflectionUtils.cast(SqlUtils.getFailedItems(this.items, this.insertOrUpdateResult));
    }
}

