/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public interface Dialect {
    public String limit();

    public String limitAndOffset();

    default public String selectForUpdateSkipLocked() {
        return "";
    }

    default public String escape(String toEscape) {
        return toEscape;
    }

    default public void setParam(PreparedStatement ps, int i, Object o) throws SQLException {
        if (o instanceof String) {
            this.setString(ps, i, (String)o);
        } else if (o instanceof UUID) {
            this.setUUID(ps, i, (UUID)o);
        } else if (o instanceof Integer) {
            this.setInt(ps, i, (Integer)o);
        } else if (o instanceof Long) {
            this.setLong(ps, i, (Long)o);
        } else if (o instanceof Double) {
            this.setDouble(ps, i, (Double)o);
        } else if (o instanceof Boolean) {
            this.setBoolean(ps, i, (Boolean)o);
        } else if (o instanceof Instant) {
            this.setTimestamp(ps, i, (Instant)o);
        } else if (o instanceof Duration) {
            this.setDuration(ps, i, (Duration)o);
        } else if (o instanceof Enum) {
            this.setEnum(ps, i, (Enum)o);
        } else if (o == null) {
            ps.setTimestamp(i, null);
        } else {
            throw new IllegalStateException(String.format("Found a value which could not be set in the PreparedStatement: %s: %s", o.getClass(), o));
        }
    }

    default public void setString(PreparedStatement ps, int i, String stringValue) throws SQLException {
        ps.setString(i, stringValue);
    }

    default public void setUUID(PreparedStatement ps, int i, UUID uuidValue) throws SQLException {
        ps.setString(i, uuidValue.toString());
    }

    default public void setInt(PreparedStatement ps, int i, Integer intValue) throws SQLException {
        ps.setInt(i, intValue);
    }

    default public void setLong(PreparedStatement ps, int i, Long longValue) throws SQLException {
        ps.setLong(i, longValue);
    }

    default public void setDouble(PreparedStatement ps, int i, Double doubleValue) throws SQLException {
        ps.setDouble(i, doubleValue);
    }

    default public void setBoolean(PreparedStatement ps, int i, boolean boolValue) throws SQLException {
        ps.setInt(i, boolValue ? 1 : 0);
    }

    default public void setTimestamp(PreparedStatement ps, int i, Instant instant) throws SQLException {
        ps.setTimestamp(i, Timestamp.from(instant), Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC)));
    }

    default public void setDuration(PreparedStatement ps, int i, Duration duration) throws SQLException {
        ps.setString(i, duration.toString());
    }

    default public void setEnum(PreparedStatement ps, int i, Enum enumValue) throws SQLException {
        ps.setString(i, enumValue.name());
    }
}

