/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.db;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SqlUtils {
    private SqlUtils() {
    }

    public static <T> List<T> getSucceededItems(List<T> items, int[] insertOrUpdateResult) {
        return IntStream.range(0, insertOrUpdateResult.length).filter(i -> SqlUtils.hasBatchInsertOrUpdateSucceeded(insertOrUpdateResult[i])).mapToObj(items::get).collect(Collectors.toList());
    }

    public static <T> List<T> getFailedItems(List<T> items, int[] insertOrUpdateResult) {
        List<T> succeededItems = SqlUtils.getSucceededItems(items, insertOrUpdateResult);
        ArrayList<T> result = new ArrayList<T>(items);
        result.removeAll(succeededItems);
        return result;
    }

    private static boolean hasBatchInsertOrUpdateSucceeded(int insertOrUpdateResult) {
        return insertOrUpdateResult == -2 || insertOrUpdateResult > 0;
    }
}

