/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.db;

import java.sql.Connection;
import java.sql.SQLException;

public class Transaction
implements AutoCloseable {
    private final Connection conn;
    private final boolean originalAutoCommit;
    private boolean committed;

    public Transaction(Connection conn) throws SQLException {
        this.conn = conn;
        this.originalAutoCommit = conn.getAutoCommit();
        if (this.originalAutoCommit) {
            conn.setAutoCommit(false);
        }
    }

    public void commit() throws SQLException {
        this.conn.commit();
        this.committed = true;
    }

    @Override
    public void close() throws SQLException {
        if (!this.committed) {
            this.conn.rollback();
        }
        if (this.originalAutoCommit != this.conn.getAutoCommit()) {
            this.conn.setAutoCommit(this.originalAutoCommit);
        }
    }
}

