/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.mapper;

import org.jobrunr.jobs.Job;
import org.jobrunr.storage.navigation.AmountRequest;
import org.jobrunr.storage.navigation.OffsetBasedPageRequest;
import org.jobrunr.storage.sql.common.JobTable;
import org.jobrunr.storage.sql.common.db.Dialect;
import org.jobrunr.storage.sql.common.db.Sql;
import org.jobrunr.storage.sql.common.mapper.SqlAmountRequestMapper;
import org.jobrunr.storage.sql.common.mapper.SqlOffsetBasedPageRequestMapper;

public class SqlJobPageRequestMapper {
    private final JobTable jobTable;
    private final SqlAmountRequestMapper sqlAmountRequestMapper;
    private final SqlOffsetBasedPageRequestMapper sqlOffsetBasedPageRequestMapper;

    public SqlJobPageRequestMapper(JobTable jobTable, Dialect dialect) {
        this.jobTable = jobTable;
        this.sqlAmountRequestMapper = new SqlAmountRequestMapper(dialect, Job.ALLOWED_SORT_COLUMNS.keySet());
        this.sqlOffsetBasedPageRequestMapper = new SqlOffsetBasedPageRequestMapper(dialect, Job.ALLOWED_SORT_COLUMNS.keySet());
    }

    public String map(AmountRequest request) {
        if (request instanceof OffsetBasedPageRequest && ((OffsetBasedPageRequest)request).getOffset() > 0L) {
            return this.sqlOffsetBasedPageRequestMapper.mapToSqlQuery((OffsetBasedPageRequest)request, (Sql)this.jobTable);
        }
        return this.sqlAmountRequestMapper.mapToSqlQuery(request, this.jobTable);
    }
}

